--Verkauf AUFTG #####################################################################################################################################

 CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_pos__next(_astat varchar, _agnr varchar)
    RETURNS integer AS $$
    DECLARE _new_pos integer;
            _AgPosW integer;
    BEGIN
      _AgPosW := TSystem.Settings__GetInteger('AG_POS_WIDTH', 1);

      _new_pos := max(ag_pos) + _AgPosW FROM auftg WHERE ag_astat = _astat AND ag_nr = _agnr;
      IF _new_pos IS NULL THEN
          _new_pos := _AgPosW; -- Neue Aufträge mit Pos.Schrittweite 10 sollen auch bei 10 anfangen.
      END IF;
      RETURN _new_pos;
    END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_pos__getfirstopen(_ag_astat varchar, _ag_nr varchar)
    RETURNS integer
    AS $$
        SELECT min(ag_pos)::integer FROM auftg WHERE ag_astat = _ag_astat AND ag_nr = _ag_nr AND NOT ag_done;
    $$ LANGUAGE sql STABLE;


 CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_dokunr__new__by__astat__get(_astat varchar DEFAULT 'E') RETURNS integer AS $$
    BEGIN
        IF _astat = 'A' AND EXISTS (SELECT 0 FROM pg_class where relname = 'auftg_ag_dokunr__astat_a__seq') THEN
            RETURN nextval('auftg_ag_dokunr__astat_a__seq');
        ELSE
            RETURN nextval('auftg_ag_dokunr_seq');
        END IF;
    END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_dokunr__createnew__by__astatnr(_astat varchar, _agnr varchar, _agpos varchar) RETURNS integer AS $$
    DECLARE _new_ag_dokunr integer;
    BEGIN
        _new_ag_dokunr := TWaWi.auftg__ag_dokunr__new__by__astat__get(_astat);

        PERFORM disableauftgtrigger();
        UPDATE auftg SET ag_dokunr = _new_ag_dokunr WHERE ag_astat = _astat AND ag_nr = _agnr AND CAST(ag_pos AS varchar) LIKE _agpos;
        PERFORM enableauftgtrigger();

        RETURN _new_ag_dokunr;
    END$$LANGUAGE plpgsql;

 --
   --BEACHTE: ULagAbgABK -> procedure TFormLagAbAbk.SqlAuftgLagABeforeInsert(Sender: TObject); Funktion wird genutzt
   --BEACHTE: TAuftg._AfterInsert(DS: TDataSet); Funktion wird genutzt
 CREATE OR REPLACE FUNCTION TWaWi.auftgi__ag_nr__generate(
      IN _parentabk integer,
      IN _mainabk integer DEFAULT NULL,
      IN _ab_tablename varchar DEFAULT NULL,
      IN _ab_dbrid varchar DEFAULT NULL,
      IN _ab_keyvalue varchar DEFAULT NULL
      )
      RETURNS varchar
      AS $$
      DECLARE result varchar;
      BEGIN
        -- Direktbezug zu LDSDOK
        SELECT ld_auftg || '-' || LPAD(ld_pos::varchar, 2, '0') INTO result FROM ldsdok WHERE ld_abk = tabk.abk_main_abk(_parentabk);
        -- Direktbezug zu AUFTG (Fertigungsprojekt)
        IF result IS NULL THEN
           SELECT ag_nr || '/' || LPAD(ag_pos::varchar, 2, '0') INTO result FROM auftg WHERE ag_ownabk = _parentabk;--hier sollte nur einmalig die erste ebene reinspringen. ab der 2. hätten wir wieder lds-bezug. daher hier "/" um gleiche syntax zu erreichen, als wäre für die pos des Fertigungsprojektes ein ldsdok da
           IF result LIKE 'AG%' THEN
              result := 'PP' || Substring(result FROM 3) || '-XX'; -- -XX eintragen, weil wie keine Position haben
           END IF;
        END IF;
        -- Struktur-ABK
        IF result IS NULL THEN
           IF    _ab_tablename = 'ldsdok' THEN
               result := coalesce( (SELECT ld_auftg || '-' || LPAD(ld_pos::varchar, 2, '0') FROM ldsdok WHERE dbrid = _ab_dbrid), -- https://redmine.prodat-sql.de/issues/18934?issue_count=14&issue_position=5&next_issue_id=19266&prev_issue_id=19264#note-11
                                    _ab_keyvalue
                                 );
           ELSIF _ab_tablename = 'anl' THEN
               result := 'P-'  || _ab_keyvalue;
           ELSIF _ab_tablename = 'qab' THEN
               result := 'SV-' || _ab_keyvalue;
           ELSIF _ab_tablename = 'vertrag' THEN
               result := 'VT-' || _ab_keyvalue;
           END IF;

           IF coalesce(result,'') = '' THEN
               result := 'ABK-'|| _parentabk;--!!!FALLBACK!!!
           END IF;
        END IF;
        --
        RETURN result;
      END $$ LANGUAGE plpgsql;
 --
 -- Norm für Auftrag vorschlagen, 'Kunden für Artikel' > Debitorendaten > Art.Norm
 CREATE OR REPLACE FUNCTION twawi.auftg__ag_nident__by__aknr_lkn(IN aknr VARCHAR, IN adkrz VARCHAR) RETURNS VARCHAR AS $$
  DECLARE nident VARCHAR;
  BEGIN

   nident:=NULL;

   IF aknr IS NOT NULL AND adkrz IS NOT NULL THEN

     -- Nachschauen in Kunden für Artikel
     SELECT az_nident INTO nident FROM artzuo WHERE az_pronr = aknr AND az_prokrz = adkrz;
     IF nident IS NOT NULL THEN
       RETURN nident;
     END IF;

     -- Nachschauen in Debitorendaten
     SELECT a1_norm INTO nident FROM adk1 WHERE a1_krz = adkrz;
     IF nident IS NOT NULL THEN
       RETURN nident;
     END IF;

   END IF;

   -- Wenn keine Kundenspezifische Norm gefunden wurde, nehmen wir Fertigungsnorm aus Artikelstamm
   IF aknr IS NOT NULL THEN
     SELECT ak_norm INTO nident FROM art WHERE ak_nr = aknr;
   END IF;

   RETURN nident;
  END $$ LANGUAGE plpgsql STABLE;

 -- Ermittlung der aktuell zu reservierenden Menge des Artikels im Auftrag. #8657
 CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_stkres__calc(IN in_agid INTEGER, IN in_aknr VARCHAR) RETURNS NUMERIC AS $$
  DECLARE stkres_calc NUMERIC;
  BEGIN
    IF in_agid IS NULL AND in_aknr IS NULL THEN RETURN NULL; END IF; -- keine Daten, dann raus mit NULL.

    IF TSystem.Settings__GetBool('auftg_ag_stkres_calc') THEN
        IF in_aknr IS NULL THEN
            in_aknr:= ag_aknr FROM auftg WHERE ag_id = in_agid; -- versuche Artikelnummer der Auftragspos zu finden.
        END IF;

        stkres_calc:= (
            SELECT ak_tot                                    -- aktuell lagernd abzüglich der
                    - coalesce(
                         (SELECT sum(numeric_larger(
                                        -- coalesce: andere Aufträge ohne Reservierung belasten dennoch den Lagerbestand?!
                                        -- Widerspruch: entweder ich will explizit reservieren, dann zählen nur Aufträge mit einem Wert in stkres
                                        -- Oder ich "mindernd" reservieren
                                        -- Funktion ist sinnlos und soll abgeschafft werden.
                                        -- mMn ausschliesslich bei Fetzel in Verwendung, daher erstmal jetzt so (Stand 2021/02)
                                        coalesce(nullif(ag_stkres_uf1, 0),
                                                 ag_stk_uf1 - ag_stkb
                                                 )
                                        - ag_stkl
                                        ,0
                                        )
                                    )                        -- restlichen reservierten Mengen. Dabei Überlieferungen beachten! (nicht unter 0)
                            FROM auftg                       -- der anderen offenen Aufträge des Artikels
                           WHERE ag_aknr = ak_nr
                             AND NOT ag_done
                             AND ag_id IS DISTINCT FROM in_agid
                         )
                         , 0
                      )
              FROM art
             WHERE ak_nr = in_aknr
        );
    END IF;

    RETURN numeric_larger(coalesce(stkres_calc, 0), 0);
  END $$ LANGUAGE plpgsql STABLE;
--
--
--Einkauf LDSDOK #####################################################################################################################################
 CREATE OR REPLACE FUNCTION TWaWi.ldsdok__ld_pos__next(ldcode VARCHAR, ldauftg VARCHAR) RETURNS INTEGER AS $$
     DECLARE   I INTEGER;
           Step INTEGER;
     BEGIN
      SELECT TSystem.Settings__GetInteger('LD_POS_WIDTH', 1) INTO step;
      --
      I:=max(ld_pos) FROM ldsdok WHERE ldsdok.ld_code=ldcode AND ldsdok.ld_auftg=ldauftg;
      --
      IF I IS NULL THEN
        I:=step;
      ELSE
        I:=I+Step;
      END IF;
      --
      RETURN I;
     END$$LANGUAGE plpgsql;
 CREATE FUNCTION z_99_deprecated.nextldpos(ldcode VARCHAR, ldauftg VARCHAR) RETURNS INTEGER AS $$
     SELECT TWaWi.ldsdok__ld_pos__next(ldcode, ldauftg);
     $$ LANGUAGE sql;

 --Interne Bestellung erstellen: LdsDokI
 CREATE OR REPLACE FUNCTION TWaWi.LdsDokI__create__from__auftg(
     IN  _agid     integer,
     IN  _ldekref  varchar = NULL,
     OUT ldid     integer
     )
     RETURNS integer
     AS $$
     DECLARE v_ld_auftg varchar;
     BEGIN

        v_ld_auftg := (TEinkauf.Generate_Bestellnummer_Ext('I', _agid)).nummer;

        INSERT INTO ldsdok
                    (ld_code,
                     ld_auftg,
                     ld_pos,
                     ld_kn,
                     ld_aknr,
                     ld_stk,
                     ld_term,
                     ld_ag_id,
                     ld_mce,
                     ld_ekref,
                     ld_an_nr
                     )
             SELECT
                    'I',
                    v_ld_auftg,
                    IFTHEN(TSystem.Settings__GetBool('ld_auftg=ag_nr_add_pos'),
                           TWaWi.ldsdok__ld_pos__next('I', v_ld_auftg),
                           p_pos
                          ), --wenn PA-Nr = AG-Nr/AG-Pos, dann kann die Nummer immer mit 1 starten
                    '#',
                    p_aknr,
                    p_mengeo,
                    timediff_substdays(p_datum_istsoll, TSystem.Settings__GetInteger('PT_ldsdoki__from__auftg__substdays', 1), true, true),
                    p_id,
                    p_me,
                    coalesce(_ldekref, p_refnummer),
                    p_an_nr
               FROM TWawi.Auftg_PosExt
                    --auftg JOIN art ON ak_nr=ag_aknr AND ak_fertigung
              WHERE p_id = _agid
                AND p_IsFertigung
                AND p_mengeo > 0
          RETURNING ld_id INTO ldid;

        RETURN;
     END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION TWawi.LdsDokI__create__from__auftgi(
     IN  _ag_id       integer,
     IN  _menge       numeric = NULL,
     IN  _menge_soll  numeric = NULL,
     IN  _ld_abk      integer = NULL,
     IN  _ld_stat     varchar = NULL,
     IN  _ld_ekref    varchar = NULL,
     OUT ldid         integer
     )
     AS $$
     BEGIN
        INSERT INTO ldsdok
                    (ld_code, ld_auftg, ld_pos,
                     ld_kn, ld_aknr, ld_akbz,
                     ld_stk, ld_stk_soll,
                     ld_mce,
                     ld_abk,
                     ld_term,
                     ld_nident,
                     ld_interncreate,
                     ld_ag_id,
                     ld_stat,
                     ld_ekref,
                     ld_kontakt,
                     ld_an_nr
                     )
             SELECT 'I',
                    CASE WHEN p_stat IN ('F-ABK') THEN
                        (TEinkauf.Generate_Bestellnummer_Ext('I', p_id)).nummer
                    ELSE
                        p_nummer
                    END,
                    NULL, -- LG 11/2018 p_pos entfernt. Es wird ggf. mehrfach eine Teilmenge ausgelöst. Die Pos. muss daher dynamisch hochzählen.
                    '#',
                    p_aknr,
                    p_akbez,
                    coalesce( _menge, p_mengeo ),
                    _menge_soll,
                    p_me,
                    _ld_abk, --die erstellte ldsdok direkt mit einer abk verbinden (Bestellung mit FolgeABK #8618)
                    timediff_substdays(p_datum_istsoll, 1, true, true),
                    p_norm,
                    true,
                    p_id,
                    _ld_stat,
                    coalesce( _ld_ekref, p_refnummer ),
                    p_apint,
                    p_an_nr
               FROM TWawi.Auftg_PosExt
                    --auftg JOIN art ON ak_nr=ag_aknr AND ak_fertigung
              WHERE p_id = _ag_id
                AND (     p_IsFertigung
                      OR (p_stat IN ('F-ABK'))
                     )
                AND coalesce( _menge, p_mengeo ) > 0
          RETURNING ld_id INTO ldid;

        -- Zusammenhang zw. ABK und Interner Bestellung wechselseitig herstellen: - Grund: Report ABK (wegen JOIN ldsdok)
        -- ACHTUNG: abk__b_10_i >> dort das Gleiche!
        UPDATE abk
           SET ab_ld_id = ld_id,
               ab_keyvalue = ld_auftg,
               ab_an_nr = ld_an_nr,
               ab_displaycaption = twawi.ldsdok_GenConcatNr( ldsdok )
          FROM ldsdok
         WHERE ab_ix = ld_abk
           AND ab_ld_id IS NULL
           AND ld_id = ldid
        ;

        RETURN;
     END $$ LANGUAGE plpgsql;

 CREATE OR REPLACE FUNCTION TWawi.LdsDokI__create__from__abk(
     IN  _ab_ix       integer,
     IN  _menge       numeric = NULL,
     IN  _menge_soll  numeric = NULL,
     IN  _ld_stat     varchar = NULL,
     IN  _ld_ekref    varchar = NULL,
     OUT ldid integer
     )
     AS $$
     BEGIN
        INSERT INTO ldsdok
                    (ld_code, ld_auftg, ld_pos,
                     ld_kn, ld_aknr, ld_akbz,
                     ld_stk, ld_stk_soll,
                     ld_mce,
                     ld_abk,
                     ld_term,
                     ld_nident,
                     ld_interncreate,
                     ld_ag_id,
                     ld_stat,
                     ld_ekref,
                     ld_kontakt,
                     ld_an_nr
                    )
             SELECT 'I',
                    (TEinkauf.Generate_Bestellnummer_Ext('I', p_id)).nummer,
                    NULL, --p_pos,
                    '#',
                    ab_ap_nr,
                    ab_ap_bem,
                    coalesce(_menge, ab_st_uf1),
                    _menge_soll,
                    art__standard_mgc_id(ab_ap_nr), --p_me,
                    _ab_ix, --die erstellte ldsdok direkt mit einer abk verbinden (Bestellung mit FolgeABK #8618)
                    NULL, --timediff_substdays(p_datum_istsoll, 1, true, true),
                    p_norm,
                    true,
                    NULL, --p_id, --unklar. aktuell nicht eintragen, da bei fertigungsprojekt sonst die interne bestellung nicht gelösht werden kann: diese denkt ja sie hängt als bezug an auftg?????? falls änderung unbedingt richtig prüfen
                    _ld_stat,
                    coalesce(_ld_ekref, p_refnummer),
                    p_apint,
                    coalesce(ab_an_nr, p_an_nr)
               FROM abk LEFT JOIN TWawi.Auftg_PosExt ON p_ab_ix=ab_ix
                    --auftg JOIN art ON ak_nr=ag_aknr AND ak_fertigung
              WHERE ab_ix = _ab_ix
          RETURNING ld_id INTO ldid;


        -- Zusammenhang zw. ABK und Interner Bestellung wechselseitig herstellen: - Grund: Report ABK (wegen JOIN ldsdok)
        -- ACHTUNG: abk__b_10_i >> dort das Gleiche!
        UPDATE abk
           SET ab_ld_id = ld_id,
               ab_keyvalue = ld_auftg,
               ab_an_nr = ld_an_nr,
               ab_displaycaption = twawi.ldsdok_GenConcatNr( ldsdok )
          FROM ldsdok
         WHERE ab_ix = ld_abk
           AND ab_ld_id IS NULL
           AND ld_id = ldid
        ;

        PERFORM tabk.abk__ldsdok__term_set(_ab_ix); --termin übertragen, falls abk bereits terminiert wurde (https://redmine.prodat-sql.de/issues/10617)

        RETURN;
     END $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION TWawi.LdsDokI__demontage__create(
    IN _auftg     varchar,        -- Bestellnummer / Demontage-Auftragsnummer
    IN _q_nr      integer,        -- zugehöriger QAB/SV
    IN _q_aknr    varchar,        -- Quellartikelnummer
    IN _q_stk_uf1 numeric,        -- QuellMenge
    IN _q_txt     text,           -- Quellhinweistext
    IN _q_sernr   text,           -- Quellseriennummern
    IN _z_aknr    varchar = null, -- Zielartikelnummer
    IN _z_stk_uf1 numeric = null, -- ZielMenge
    IN _z_txt     text = null,    -- ZielHinweistext
    IN _z_sernr   text = null,    -- Zielseriennummern
    IN _nbedarf   boolean = null, -- nicht bedarfsdeckend
    IN _stat      varchar = null, -- 'DM': Demontage, 'UG': Upgrade, 'UB': Umbau (bei null wird im ldsdok__a_iu_demontage Trigger von Kopf übernommen)
    IN _op_ix     integer = null, -- ASK
    OUT _ldid     integer
    ) RETURNS integer AS $$
DECLARE
    _hpos        smallint;
    _agnr        varchar;
    _agid        integer;
    _aknr        varchar;
    _status      varchar;
    _stk         numeric;
    _txt         text;
    _mat_auftg   varchar;
    _parent_abk  integer;
    _nbdrf       boolean;
    _kopf_daten  boolean;
    _upos_best   boolean;
    _upos_auftg  boolean;
    _is_UG_or_UB boolean;
    _is_DM_or_UB boolean;
    _qab_dbrid   varchar;
BEGIN
    --Hauptposition bestimmen
    SELECT
        ld_pos, ld_abk, ld_stat
    FROM
        ldsdok
    WHERE
        ld_auftg = _auftg
        AND TQS.ldsdok__demontage__is(ld_id)
        AND ld_hpos IS NULL
    ORDER BY
        ld_pos
    LIMIT 1
    INTO _hpos, _parent_abk, _status;

    IF _parent_abk IS NOT NULL THEN
        SELECT ag_nr FROM auftg WHERE ag_parentabk = _parent_abk INTO _mat_auftg;
    END IF;

    _status := coalesce(_stat, _status); --wenn nicht als Parameter übergeben -> vom kopf ablesen

    _kopf_daten  := _hpos IS NULL;
    _is_UG_or_UB := TSystem.ENUM_GetValue(_status, 'UG') OR TSystem.ENUM_GetValue(_status, 'UB');
    _is_DM_or_UB := TSystem.ENUM_GetValue(_status, 'DM') OR TSystem.ENUM_GetValue(_status, 'UB');
    _upos_best   := _is_DM_or_UB AND NOT _kopf_daten AND _z_aknr IS NULL;
    _upos_auftg  := _is_UG_or_UB AND NOT _kopf_daten AND _q_aknr IS NULL;

    --bedarfsdeckend? ACHTUNG: Standardwerte im Trigger ldsdok__a_iu_demontage() wenn '_nbedarf' nicht gefüllt
    IF _kopf_daten THEN
        _nbdrf := TSystem.ENUM_GetValue(_status, 'DM'); --Kopfposition: DM - true, UG/UB - false
    ELSE
        _nbdrf := coalesce(_nbedarf, false);          --Unterpositionen: false (bedarfsdeckend oder Benutzereingabe)
    END IF;

    --Bestellung anlegen
    IF _kopf_daten AND _is_UG_or_UB THEN
        --Zieldaten
        _aknr := _z_aknr;
        _stk  := _z_stk_uf1;
        _txt  := _z_txt;
    ELSE
        --Quelldaten
        _aknr := _q_aknr;
        _stk  := _q_stk_uf1;
        _txt  := _q_txt;
    END IF;
    --
    IF     _kopf_daten
        OR _upos_best
    THEN
        INSERT INTO ldsdok(ld_code,
                           ld_auftg,
                           ld_pos,
                           ld_aknr,
                           ld_stk,
                           ld_txtint,
                           ld_hpos,
                           ld_stat,
                           ld_nbedarf,
                           ld_q_nr,
                           ld_kn
                          )
                   VALUES ('I',
                           _auftg,
                           TWaWi.ldsdok__ld_pos__next('I', _auftg),
                           _aknr,
                           _stk,
                           _txt,
                           _hpos,
                           _status,
                           _nbdrf,
                           _q_nr,
                           '#'
                          )
        RETURNING ld_id INTO _ldid;
    END IF;

    IF _kopf_daten THEN
        -- ABK (Kopfposition)
        SELECT dbrid FROM qab WHERE q_nr = _q_nr INTO _qab_dbrid;
        _parent_abk := tabk.abk__create(_aknr, _op_ix, _stk, NULL, NULL, _ldid, 'qab', _qab_dbrid, _status);

        IF _is_UG_or_UB THEN
            --Einkauf -> Seriennummern (nur Kopfdatensatz Upgrade/Umbau)
            PERFORM tlager.lagsernr__mapsernr__vorgabesernr__extract_from_text(_z_sernr, _ldid);
        END IF;
        --sonst wurde parent_abk am Anfang vom Kopf genommen
    END IF;

    --Auftrag zur ABK anlegen
    IF _kopf_daten THEN
        --Quelldaten
        _aknr := _q_aknr;
        _stk  := _q_stk_uf1;
        _txt  := _q_txt;
    ELSE
        --Zieldaten
        _aknr := _z_aknr;
        _stk  := _z_stk_uf1;
        _txt  := _z_txt;
    END IF;

    IF     _kopf_daten
        OR (_upos_auftg AND _is_UG_or_UB)
    THEN
        _agnr := coalesce(_mat_auftg, getnumcirclenr('ldsdoki')); --für Kopf - neu, für unterpositionen - mat_auftg
        --RAISE NOTICE 'parent_abk: %, agnr: %', parent_abk, agnr;

        -- Auftrag
        INSERT INTO auftg(ag_astat,
                          ag_nr,
                          ag_pos,
                          ag_aknr,
                          ag_stk,
                          ag_txt,
                          ag_parentabk,
                          ag_mainabk,
                          --ag_nbedarf,  --erst nicht setzen
                          ag_stat
                         )
                  VALUES ('I',
                          _agnr,
                          TWaWi.auftg__ag_pos__next('I', _agnr),
                          _aknr,
                          _stk,
                          _txt,
                          _parent_abk,
                          _parent_abk,
                          --nbedarf,
                          IFTHEN(_kopf_daten, _status, NULL)
                         )
        RETURNING ag_id INTO _agid;

        IF _agid IS NOT NULL THEN
            --Projektübersicht->Materialliste->Serien-Nr. (nur Kopfdatensatz Demontage/Upgrade)
            UPDATE auftgmatinfo SET agmi_sernr = _q_sernr WHERE agmi_ag_id = _agid;
        END IF;

        PERFORM TSystem.num_unreserve('ldsdoki', _agnr);
    END IF;
    RETURN;
END $$ LANGUAGE plpgsql;

 ---
 CREATE OR REPLACE FUNCTION TWawi.ldsdoki__from__ldsdok__folgeabk(_ld_id integer) RETURNS ldsdok
     AS $$
     DECLARE r ldsdok;
     BEGIN
       -- Produktionsauftrag (FolgeABK) zur externen Bestellung finden; #9530
       -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/FolgeABK
       -- SELECT ld_abk, ld_code, ld_auftg, ld_stat FROM TWawi.ldsdoki__ld_id__from__ldsdok__folgeabk(in_ld_id)
       SELECT pa.*
         INTO r
         FROM ldsdok AS best
         LEFT JOIN abk ON ((ab_dbrid = best.dbrid) AND TSystem.ENUM_GetValue(ab_stat, 'F-ABK'))
         LEFT JOIN ldsdok AS pa ON ((pa.ld_abk = ab_ix) AND (pa.ld_code = 'I') AND TSystem.ENUM_GetValue(pa.ld_stat, 'F-ABK'))
        WHERE (best.ld_code = 'E')
          AND (best.ld_id = _ld_id)
          AND TSystem.ENUM_GetValue(best.ld_stat, 'F-ABK');

       RETURN r;
     END $$ LANGUAGE plpgsql;
 -- gibt alle Kontrollmerkmale zu den angegebenen Artikeln zurück. Diese können dann in die Zieltabelle eingefügt werden
CREATE OR REPLACE FUNCTION twawi.einkauf__artPruefung__create__from__bestellvorschlag__jsonb(
        IN  _bvp_id integer,
        OUT out_recs_artPruefung jsonb[]
        )
        RETURNS jsonb[]
        AS $$
        DECLARE _artPruefung_aknrs varchar[];
                r record;
        BEGIN

            -- Kontrollmerkmale #8205 #7968 #7757 #8207 : für Artikel selbst sowie Übergeordneten Bedarfsverursacher (optional über flags gesteuert) => ACHTUNG TWawi.beleg_p__einkauf__create__from__bestellvorschlag__jsonb identisch!!!!
            -- Artikel selbst
            _artPruefung_aknrs := array_append( _artPruefung_aknrs, bvp_aknr ) FROM BestVorschlagPos WHERE bvp_id = _bvp_id;

            -- Kontrollmerkmal KopfArtikel (ich bin ein Rohmat, welches von einem Artikel mit Prüfung benötigt wird; https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Bestellvorschlag_BSV_ArtPruefungTest
            -- SELECT into oder direkte Zuweisung führt zur Leerung des Array, wenn kein Treffer
            FOR r IN
                SELECT ld_aknr
                  FROM ldsauftg
                  JOIN auftg ON la_ag_id = ag_id
                  JOIN ldsdok ON ld_abk = ag_mainabk
                 WHERE la_bvp_id = _bvp_id
            LOOP
                -- #12873
                _artPruefung_aknrs := array_append( _artPruefung_aknrs, r.ld_aknr );
            END LOOP;


            -- Holen aller Merkmale: zum Artikel sowie zu allen Kopfartikeln, die zu diesem Bedarf führen
            -- Weiterhin die Merkmale des AC CHNR-QS wenn ak_chnrreq
            SELECT array_agg( to_jsonb( artPruefung ) )
              INTO out_recs_artPruefung
              FROM artPruefung
              LEFT JOIN art ON ak_nr = apr_apnr
             WHERE (
                       apr_eing
                    OR
                       ( apr_web AND TSystem.Settings__GetBool('chkArtPRWebLdsdok') )
                   )
               AND (
                     -- TODO mehrfach calls unnest auflösen
                     -- Artikel hat selbst Kontrollmerkmal
                        apr_aknr IN ( SELECT * FROM unnest(_artPruefung_aknrs ) )

                     --AC hat Kontrollmerkmal
                    OR ( apr_ac IN ( SELECT ak_ac FROM art WHERE ak_nr IN ( SELECT * FROM unnest( _artPruefung_aknrs ) ) ) )

                     -- Artikel ist Chargennummernpflichtig UND Kontrollmerkmale aus entsprechenden AC
                    OR (      apr_ac = 'CHNR-QS'
                        AND EXISTS( SELECT true FROM art WHERE ak_nr IN ( SELECT * FROM unnest( _artPruefung_aknrs ) ) AND ak_chnrreq ) )
                   )

            ;

            RETURN;
        END $$ LANGUAGE plpgsql;
--
-- Einkaufspreise suchen

  /* Überlegungen von wegen potentielle Änderungen
   * 01 TWawi.sql im Erzeugungsscript nach Tabellenerstellung verlagern (andere Funktions-Dateien mitnehmen ? )
   * Preistyp aufräumen (Namenskonventionen, Feldanzahl?)
   * Table Preise wieder abschaffen. Derzeit nur für Banf benutzt.
   * Ab- / Zuschlagsbehandlung vereinfachen, wenn die überarbeitet wurden
   ** Flag in Tabelle an der die hängen, ob es Abzu gibt von abzutable__a_iud aktualisieren
   ** Abzu-Typen einführen (Pro Dokument / Pro Pos absolut / Pro ME absolut / Prozentual auf Wert) => Ticket: http://redmine.prodat-sql.de/issues/5813
   ** Berechnung der Abzu-Summen vereinheitlichen
  */


  -- Setzt den Währungskurs rückwirkend zu einem bestimmten Datum in offenen Belegen
CREATE OR REPLACE FUNCTION TWawi.UpdateWaKurs(IN kursdatum DATE, IN newKurs NUMERIC, IN waco VARCHAR(3) ) RETURNS VOID AS $$
   DECLARE fakU  RECORD;
      rows   INTEGER;
      bzrows INTEGER;
      msg    VARCHAR;
   BEGIN

    msg:='';

    -- Rechnet automatisch neu durch
    UPDATE auftg SET ag_kurs = newKurs FROM adk1
    WHERE (NOT ag_done)
       AND ag_astat <> 'I'
       AND a1_krz = ag_krzf
       AND a1_waco = waco
       AND ag_kurs <> newKurs
       AND ag_datum >= kursdatum;

    GET DIAGNOSTICS rows = ROW_COUNT;
    IF (rows > 0) THEN msg := lang_text(13262) || E'\n' || rows::VARCHAR || ' ' || lang_text(13258); END IF;
    bzrows:=0;
    -- Muss manuell durchgerechnet werden
    FOR faku IN SELECT be_bnr FROM belkopf WHERE (NOT be_def) AND (be_waco = waco) AND (be_umr <> newKurs) AND (be_bdat >= kursdatum) LOOP

    UPDATE belabzu SET beaz_tot = 0     WHERE beaz_bebnr = faku.be_bnr;
    UPDATE belzeil_grund SET bz_tot = 0 WHERE bz_be_bnr  = faku.be_bnr;
    GET DIAGNOSTICS rows = ROW_COUNT;
    bzrows:=bzrows+rows;
    UPDATE belkopf SET be_umr = newkurs WHERE be_bnr     = faku.be_bnr;

    END LOOP;

    IF (bzrows > 0) THEN msg := IfThen( msg = '',
              lang_text(13262) || E'\n' || rows::VARCHAR || ' ' || lang_text(13259),
                     msg || E'\n' || bzrows::VARCHAR || ' ' || lang_text(13259) ); END IF;

    -- Rechnet automatisch neu durch
    UPDATE ldsdok SET ld_kurs = newkurs
    WHERE NOT ld_done
      AND ld_code <> 'I'
      AND ld_waer = waco
      AND ld_kurs <> newKurs
      AND ld_datum >= kursdatum;
    GET DIAGNOSTICS rows = ROW_COUNT;
    IF (rows > 0) THEN msg := IfThen( msg = '',
              lang_text(13262) || E'\n' || rows::VARCHAR || ' ' || lang_text(13260),
                     msg || E'\n' || rows::VARCHAR || ' ' || lang_text(13260) ); END IF;

    -- Rechnet automatisch neu durch
    UPDATE belegpos SET belp_kurs = newkurs
    WHERE NOT belp_erledigt
      AND belp_belegtyp = 'ERG'
      AND belp_waehr = waco
      AND belp_kurs <> newKurs
      AND belp_erstelldatum >= kursdatum;
    GET DIAGNOSTICS rows = ROW_COUNT;
    IF (rows > 0) THEN msg := IfThen( msg = '',
          lang_text(13262) || E'\n' || rows::VARCHAR || ' ' ||  lang_text(13261),
                 msg || E'\n' || rows::VARCHAR || ' ' || lang_text(13261) ); END IF;


    IF (msg='') THEN msg:=lang_text(10602); END IF; -- Keine Daten gefunden
    PERFORM PRODAT_TEXT(msg);
    /* msg ist sowas wie:
     Umrechnungskurs wurde aktualisiert für:
      5 Auftragspositionen
      3 Rechnungspositionen
      1 Eingangsrechnungspositionen
    */

    RETURN;
   END $$ LANGUAGE plpgsql VOLATILE RETURNS NULL ON NULL INPUT;
  --


  --OBSOLET? - NEUE FUNKTIONEN AUS TICKET #5813 verwenden? [Kopieren von Ab-/Zuschlägen aus einem Datensatz von Src_Table zu einem Datensatz in trg_Table]
  -- [TODO: Prüfen wo verwendet und raus]
  -- TODO ====> NUR teinkauf.create_bestellungfrombanf noch aufräumen! Dann weg? Oder?
CREATE OR REPLACE FUNCTION TWawi.Create_Abzu(IN src_table VARCHAR, IN src_dbrid VARCHAR, IN trg_table VARCHAR, IN trg_dbrid VARCHAR) RETURNS BOOLEAN AS $$
   BEGIN

    --Abzuschlag aus Rahmenbestellung
    IF src_table = 'ldsdok' THEN
    IF trg_table = 'ldsdok' THEN
      INSERT INTO ldsabzu (ldaz_ld_id, ldaz_abz_id, ldaz_anz, ldaz_betr, ldaz_konto, ldaz_steucode, ldaz_steuproz, ldaz_canSkonto, ldaz_zutxt)
      SELECT trg.ld_id, ldaz_abz_id, ldaz_anz, ldaz_betr, ldaz_konto,
       trg.ld_steucode, trg.ld_steuproz,
       ldaz_canSkonto, ldaz_zutxt
      FROM ldsabzu
       JOIN ldsdok AS src ON src.ld_id = ldaz_ld_id AND src.dbrid = src_dbrid
       JOIN ldsdok AS trg ON trg.dbrid = trg_dbrid
       JOIN abzu ON abz_id = ldaz_abz_id
      WHERE abz_einkauf;

      IF FOUND THEN
        RETURN TRUE;
      ELSE
        RETURN FALSE;
      END IF;

      -- alternative Prüfung ob alles übernommen wurde.
      -- BOOL_AND(SELECT abzu_src.ldaz_abz_id = abzu_trg.ldaz_abz_id
      -- FROM ldsabzu AS abzu_src JOIN ldsdok AS src ON src.ld_id = abzu_src.ldaz_ld_id AND src.dbrid = src_dbrid
      -- LEFT JOIN ldsdabzu AS abzu_trg ON abzu_src.ldaz_abz_id = abzu_trg.ldaz_abz_id LEFT JOIN ldsdok AS trg ON trg.ld_id = abzu_trg.ldaz_ld_id AND trg.dbrid = trg_dbrid)
    END IF;
    END IF;

    --Abzuschlag aus Lieferantendaten
    IF src_table = 'epreis' THEN
    IF trg_table = 'ldsdok' THEN
      INSERT INTO ldsabzu (ldaz_ld_id, ldaz_abz_id, ldaz_anz, ldaz_betr, ldaz_konto, ldaz_steucode, ldaz_steuproz, ldaz_canSkonto)
      SELECT trg.ld_id, eaz_abz_id, eaz_anz, eaz_betr, abzu.abz_konto,
       trg.ld_steucode, trg.ld_steuproz,
       eaz_canSkonto
      FROM epreisabzu
       JOIN epreis AS src ON src.e_id = eaz_e_id AND src.dbrid = src_dbrid
       JOIN ldsdok AS trg ON trg.dbrid = trg_dbrid
       JOIN abzu ON abz_id = eaz_abz_id
      WHERE abz_einkauf;

      IF FOUND THEN
        RETURN TRUE;
      ELSE
        RETURN FALSE;
      END IF;

      -- alternative Prüfung ob alles übernommen wurde.
      -- BOOL_AND(SELECT abzu_src.ldaz_abz_id = abzu_trg.ldaz_abz_id
      -- FROM epreisabzu AS abzu_src JOIN epreis AS src ON src.e_id = abzu_src.eaz_e_id AND src.dbrid = src_dbrid
      -- LEFT JOIN ldsdabzu AS abzu_trg ON abzu_src.eaz_abz_id = abzu_trg.ldaz_abz_id LEFT JOIN ldsdok AS trg ON trg.ld_id = abzu_trg.ldaz_ld_id AND trg.dbrid = trg_dbrid)
    END IF;
    END IF;
    RETURN FALSE;
   END $$ LANGUAGE plpgsql VOLATILE RETURNS NULL ON NULL INPUT;
   --SELECT twawi.Create_Abzu('epreis', '60998110', 'ldsdok', '64761034'); -- Bsp ART1 BEISPIELADRESSE-TES nach E 23000507 10
   --SELECT twawi.Create_Abzu('ldsdok', '64761034', 'ldsdok', '64761034'); -- Bsp E 23000507 10

  --



  --

  -- Baut die Defaults für einen leeren Einkaufspreis zu einer Vorgabe zusammen
CREATE OR REPLACE FUNCTION TWawi.Create_Preis(IN EKPreis BOOLEAN DEFAULT true) RETURNS TWawi.Preis AS $$
    DECLARE p TWawi.Preis;
    BEGIN
    p.IsValid               := False;
    p.preis                 := 0;
    p.preiseinheit          := 1;
    p.preis_uf1             := 0;
    p.preis_uf1_basisw      := 0;
    p.preis_uf1_basisw_abzu := 0;
    p.Menge                 := 0;
    p.Menge_los             := 0;
    p.ad_krz                := NULL;
    p.ak_nr                 := NULL;
    p.datum                 := NULL;
    p.datum_bis             := NULL;
    p.rabatt                := 0;
    p.los                   := 0;
    p.kurs                  := 1;
    p.artmgcid              := NULL;
    p.hasabzu               := FALSE;
    p.source_bez            := NULL;
    p.source_table          := NULL;
    p.source_dbrid          := NULL;
    p.minPreis              := NULL;
    p.maxPreis              := NULL;
    p.abzubetrag_uf1_basisw := 0;
    p.wacode                := TSystem.Settings__Get('BASIS_W');
    p.aknr_referenz         := NULL;
    IF EKPreis THEN -- Vorgabe EK- oder VK-Steuersatz
      SELECT steu_z, steu_proz INTO p.steucode, p.steuproz FROM steutxt WHERE steu_z = TSystem.Settings__Get('einksteucode');
    ELSE
      SELECT steu_z, steu_proz INTO p.steucode, p.steuproz FROM steutxt WHERE steu_z = TSystem.Settings__Get('auftgsteucode');
    END IF;

    RETURN p;
    END $$ LANGUAGE plpgsql IMMUTABLE;
  --

CREATE OR REPLACE FUNCTION TWawi.epreis__fixierter_lieferant__check(
        _aknr varchar
    ) RETURNS varchar AS $$
    BEGIN

        IF
            EXISTS(
              SELECT true
                FROM epreis
               WHERE e_aknr = _aknr
                     -- gültig muss er sein
                 AND current_date BETWEEN e_gdatum AND coalesce( e_bisdatum, 'infinity' )
                 AND tsystem.enum_getvalue( e_stat, 'F' )
            )
        THEN

            RETURN 'epreis_fixierter_Stammlieferant__xtt32640,' || e_lkn
              FROM epreis
             WHERE e_aknr = _aknr
               AND tsystem.enum_getvalue( e_stat, 'F' )
               AND current_date BETWEEN e_gdatum AND coalesce( e_bisdatum, 'infinity' )
               -- notwendig falls 2mal der gleiche Lieferant eingetragen ist
             GROUP BY 1
            ;

        END IF;

        RETURN null;

    END $$ language plpgsql;


-- Baut einen Einkaufspreis der aus der angegebenen Preisquelle stammt zusammen und die gewünschte Menge in GME repräsentiert.
CREATE OR REPLACE FUNCTION TWawi.Create_Preis(
    IN srcTable   varchar(40),                -- Quelltabelle
    IN srcDBRID   varchar(32),                -- Datensatz der Quelltabelle
    IN mengeGME   numeric(12,4) = null,       -- Menge in Grundmengeneinheit des Artikels. Ohne Angabe wird auf die Menge der Preisquelle zurückgegangen (z.Bsp. Lieferantenlos, ERG-Menge etc.)
    IN RoundToLos boolean = true              -- True, rundet auf Losgröße der Preisquelle auf
    )
    RETURNS TWawi.Preis
    AS $$
    DECLARE
        EKRahmenRestAbrufen boolean;
        AbzuBetrag  numeric(12,4);
        AbzuAnzahl  integer;
        detailDBRID varchar;
        p TWawi.Preis;
        r   RECORD;
        azr RECORD;
    BEGIN

      IF NullIf(srcTable,'') IS NULL OR NullIf(srcDBRID,'') IS NULL THEN RETURN NULL; END IF;

        IF current_user = 'root' THEN RAISE NOTICE '----> ENTER.TWawi.Create_Preis (%,%,%)', SrcTable, srcDBRID, mengeGME::VARCHAR; END IF;

        p := TWawi.Create_Preis(); -- Leeren Preis anlegen und initialisieren

        -- Selbstkosten Artikelstamm
        IF lower(srcTable)  = 'art' THEN

            IF Current_User='root' THEN RAISE NOTICE '----> RUN.TWawi.Create_Preis: From => Art'; END IF;

            SELECT tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(ak_nr) AS artmgcid, ak_nr, ak_hest, ak_los, dbrid INTO r
              FROM art WHERE art.dbrid = srcDBRID;

            p.IsValid               := true;
            p.ak_nr                 := r.ak_nr;
            p.artmgcid              := r.artmgcid;
            p.preis                 := coalesce(r.ak_hest, 0);
            p.preis_uf1             := coalesce(r.ak_hest, 0);
            p.preis_uf1_basisw      := coalesce(r.ak_hest, 0);
            p.Preis_uf1_basisw_abzu := coalesce(r.ak_hest, 0);
            p.Los                   := coalesce(r.ak_los, 1);  -- NULL führt zu Folgefehlern. DS meinte  mal, dass die Losgröße im Artikelstamm für den Einkauf irrelevant ist.
            p.Menge                 := coalesce(mengeGME, 1);  -- Gesuchte Menge o. Fallback auf Menge 1
            p.Menge_los             := IfThen(RoundToLos, TWawi.Round_ToLos(coalesce(p.los,0), p.menge), p.menge);
            p.datum                 := current_date;
            p.source_bez            := lang_text(13079); -- Selbstkosten (Artikelstamm)
            p.source_table          := 'art';
            p.source_dbrid          := r.dbrid;

            -- Hinweis zu eventuell vorhandenem fixierten Liefereanten
            IF Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) IS NOT null THEN
                p.status_enum := Tsystem.enum_setvalue( p.status_enum, Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) );
            END IF;

        -- Lieferantendatensatz (oder Staffeln dazu)
        ELSEIF (lower(srcTable) = 'epreis') OR (lower(srcTable) = 'epreisstaffel') THEN

            IF Current_User='root' THEN  RAISE NOTICE '----> RUN.TWawi.Create_Preis: From => epreis'; END IF;

            SELECT
                _union.*,
                m_uf AS muf,
                steu_z AS steucode,
                steu_proz
            FROM (

                  SELECT
                    epreis.*,
                    epreisstaffel.*,
                    coalesce( e_gdatum, epreis.insert_date )          AS pDate,
                    e_bisdatum                                        AS pbDate,
                    coalesce( epreisstaffel.dbrid, epreis.dbrid )     AS pDBRID
                  FROM epreis
                  LEFT JOIN epreisstaffel ON est_e_id = e_id
                  WHERE epreis.dbrid = srcDBRID

              UNION

                  SELECT
                    epreis.*,
                    epreisstaffel.*,
                    coalesce( e_gdatum, epreis.insert_date )          AS pDate,
                    e_bisdatum                                        AS pbDate,
                    coalesce( epreisstaffel.dbrid, epreis.dbrid )     AS pDBRID
                  FROM epreis
                  JOIN epreisstaffel ON est_e_id = e_id
                  WHERE epreisstaffel.dbrid = srcDBRID

            ) _union
            LEFT JOIN adk2          ON a2_krz   = e_lkn
            LEFT JOIN artmgc        ON e_mcv    = m_id
            CROSS JOIN LATERAL      steutxt__steu_z__valid_follower_get(coalesce( a2_wuco, TSystem.Settings__GetInteger('einksteucode') ))

            INTO r
            ;


            p.preis                 := coalesce(r.est_ep, r.e_preis);                                                                      -- Preis wie angezeigt, mit Preiseinheit
            p.preis_uf1             := coalesce(r.est_ep * r.muf / Do1If0(r.e_preiseinheit), r.e_ep_uf1);                                  -- Preis pro ME, ohne Preiseinheit, bei Staffeln rausrechnen
            p.preis_uf1_basisw      := coalesce(r.est_ep * r.muf * coalesce(r.e_kurs,1) / Do1If0(r.e_preiseinheit), r.e_ep_uf1_basis_w);   -- Preis pro ME, in Basiswährung, ohne Preiseinheit, bei Staffeln rausrechnen
            p.preiseinheit          := r.e_preiseinheit;
            p.los                   := r.e_stk;                              -- Losgrösse aus Lieferantendatensatz
            p.menge                 := coalesce( MengeGME * r.muf, r.e_stk); -- Gewünschte Menge (umgerechnet in Lieferantendatensatz-ME), sonst Fallback auf Losgröße
            p.menge_los             := IfThen(RoundToLos, TWawi.Round_ToLos(coalesce(p.los,0), p.menge), p.menge);
            p.ad_krz                := r.e_lkn;
            p.ak_nr                 := r.e_aknr;
            p.datum                 := r.pDate;
            p.datum_bis             := r.pbDate;
            p.rabatt                := coalesce(r.e_rab , 0);
            p.kurs                  := coalesce(r.e_kurs, 1);
            p.wacode                := r.e_waer;
            p.artmgcid              := r.e_mcv;
            p.steucode              := r.steucode;
            p.steuproz              := r.steu_proz;
            p.aknr_referenz         := r.e_best;


            -- Hinweis zu eventuell vorhandenem fixierten Liefereanten
            IF Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) IS NOT null THEN
                p.status_enum := Tsystem.enum_setvalue( p.status_enum, Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) );
            END IF;

            IF (r.est_e_id IS NULL) THEN    --Keine Staffeln
              p.Source_bez    := ifThen(r.e_Stal,lang_text(13087), lang_text(13082)); -- Stammlieferant bzw. Lieferantendaten
              p.source_table  := 'epreis';
              p.source_dbrid  := r.pdbrid;
            ELSE  --Staffenpreis
              p.source_bez    := ifThen(r.e_stal,lang_text(13084),lang_text(13083)) || ' ['||coalesce(r.est_mengevon,'0') || ' - ' || coalesce(r.est_mengebis::VARCHAR,'...') || ']'; --Stammlieferant, Staffel bzw Lieferantendaten, Staffel
              p.source_table  := 'epreisstaffel';
              p.source_dbrid  := r.pdbrid;
            END IF;

            abzubetrag := 0;
            -- Über alle Abzuschläge der Position laufen ...
            FOR azr IN SELECT eaz_betr, eaz_anz, eaz_proz, eaz_type FROM epreisabzu WHERE eaz_e_id = r.e_id LOOP

              IF coalesce(azr.eaz_proz, 0) > 0 THEN
                -- Prozentual Zuschlag => Rabattierten Positionswert nehmen => Prozentualer Abzuschlag. Ist unabhängig von Mengen u. ME, da Preisbezogen.
                abzubetrag := abzubetrag + ( p.preis_uf1_basisw * (1-coalesce(r.e_rab,0)/100) * (1-coalesce(azr.eaz_proz,0)/100));
              ELSE
                -- Abzuschläge, Betrag * Anzahl der Abzuschläge, runtergebrochen auf Betrag pro Stück in UF1. UF1 notwendig, damit Preise weiterhin vergleichbar.
                -- (PHKO, DG) Definition Fall mengeGME unter 1: Anteil der AbZu ist dann * Mindermenge (quasi Bestellmenge mind. 1 GME und dann den Anteil davon)
                -- mit / Mindermenge geht Preis gegen Unendl. (als ob die Mindermenge mit jeweiligen Zuschlag bis zu 1 GME n-fach bestellt werden würde).
                    --  ALT       abzubetrag := abzubetrag + (coalesce(azr.eaz_betr,0) * coalesce(azr.eaz_anz,0) * CASE WHEN coalesce(mengeGME,1) < 1 THEN coalesce(mengeGME,1) ELSE 1 /coalesce(mengeGME,1) END);
                    IF azr.eaz_type = 'E' THEN
                      -- einmalig pro VOrgang
                      abzubetrag := abzubetrag + azr.eaz_betr / ifthen(p.menge < p.los, p.los, p.menge);
                    ELSE
                      abzubetrag := abzubetrag + azr.eaz_betr; -- #13120 runtergebrochen auf Menge pro STK in UF1! -> damit hier nicht mit Menge multiplizieren!
                    END IF;
                  END IF;
                  p.HasAbzu := true;
                END LOOP;

              p.abzubetrag_uf1_basisw := abzubetrag * coalesce(r.e_kurs,1);
              p.preis_uf1_basisw_abzu := p.preis_uf1_basisw * (1-coalesce(r.e_rab,0)/100) + p.abzubetrag_uf1_basisw;

            p.IsValid := true;

        -- Rahmenbestellung
        ELSEIF lower(srcTable)  = 'ldsdok' THEN

            IF Current_User='root' THEN  RAISE NOTICE '----> RUN.TWawi.Create_Preis: From => ldsdok (Rahmen)'; END IF;

            SELECT ld_id, ld_auftg, ld_aknr, ld_kn, ld_arab, ld_ep_uf1_basis_w, ld_ep, ld_preis, ld_preiseinheit, ld_ep_uf1, ld_kurs, ld_mce,
                   ld_waer, ld_eklos, ld_stk, ld_stk_uf1, ld_stkl, ld_term, ld_terml,ld_done,ld_bem,
                   steu_z, steu_proz, ld_datum, ldsdok.insert_date, (SELECT stko FROM rahmen_stk_ldsdok_offen(rhmnr => ld_auftg || '/' ||  ld_pos))  AS ld_stko,
                   (ld_auftg||'/'||ld_pos) as rhl_nr, ldsdok.dbrid,
                   m_uf AS muf
              INTO r
              FROM ldsdok
              LEFT JOIN artmgc ON ld_aknr = m_ak_nr AND ld_mce = m_id
              CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get(ld_steucode)
             WHERE ldsdok.dbrid = srcDBRID;

            -- Wenn gewünschte Menge > Restmenge des Rahmens, soll Menge auf die offene Restmenge reduziert werden. Unklar ob noch benutzt, war mal für Loll.
            EKRahmenRestAbrufen := coalesce( TSystem.Settings__GetBool('EKRahmenRestAbrufen'), FALSE);

            p.preis            := r.ld_preis;
            p.preiseinheit     := r.ld_preiseinheit;
            p.preis_uf1        := r.ld_ep_uf1;
            p.preis_uf1_basisw := r.ld_ep_uf1_basis_w;

            -- Bsp: Rahmenrest - Los 100, offen 98 ... dann setzen wir das Los auf die Restmenge
            -- ld_stko  = Offene Menge  (in GME)
            -- ld_eklos = Abruflosgröße (in Rahmen-ME)

            -- Restmenge reicht nicht! Reduzieren der Abrufmenge. Ist genug da, dann entsprechend abrufen. Ohne Mengenangabe wird 1 Los abgerufen.
            IF EKRahmenRestAbrufen AND (r.ld_stko < coalesce(mengeGME, r.ld_eklos /r.muf )) THEN
               p.Los   := 0;--coalesce(r.ld_stko, 0);                    -- Los reduzieren damit nicht automatisch wieder aufgerundet wird. (Rahmen-ME)
               p.Menge := r.ld_stk_uf1 * r.muf;                      -- Als Preisbezugs-Menge wird angezeigt, was eigentlich gewünscht war (Rahmen-ME) oder Abruflos, falls keine Angabe vorhanden.
               -- p.Menge := coalesce(mengeGME * r.muf, r.ld_eklos);    -- Als Preisbezugs-Menge wird angezeigt, was eigentlich gewünscht war (Rahmen-ME) oder Abruflos, falls keine Angabe vorhanden.
               p.Menge_Los := r.ld_stko * r.muf;                     -- Abgerufene Menge ist in dem Fall die Restmenge. Losrundung wird nicht durchgeführt, auch wenn RoundToLos-Flag
               -- Es ist genug da oder wir sollen reduzieren und dürfen den Rahmen überbuchen.
               p.status_enum := 'err_ldsdokr_stk_failed__xtt13502';
            ELSE
               p.Los   := coalesce(r.ld_eklos,0);                    -- Los ist Abruflosgröße (Rahmen-ME)
               p.Menge := r.ld_stk_uf1 * r.muf;                      -- Als Preisbezugs-Menge wird angezeigt, was eigentlich gewünscht war (Rahmen-ME) oder Abruflos, falls keine Angabe vorhanden.
               p.Menge_Los := IfThen(RoundToLos, TWawi.Round_ToLos(coalesce(p.los,0), mengeGME), mengeGME);
            END IF;

            IF r.ld_term > current_date THEN
                p.status_Enum := tsystem.enum_setvalue( _list  => p.status_enum,
                                                        _value => 'ldsdokr_zukünftiger_Rahmen__xtt32614');
            END IF;
            p.kurs             := coalesce( NullIf(r.ld_kurs,0), 1);
            p.ad_krz           := r.ld_kn;
            p.ak_nr            := r.ld_aknr;
            p.datum            := coalesce(r.ld_term, r.ld_datum, r.insert_date);
            p.rabatt           := r.ld_arab;
            p.wacode           := r.ld_waer;
            p.steucode         := r.steu_z;
            p.steuproz         := r.steu_proz;
            --
            p.source_bez       := '';
            p.source_table     := 'ldsdok';
            p.source_dbrid     := r.dbrid;
            p.artmgcid         := r.ld_mce;
            p.preis_uf1_basisw_abzu:=p.preis_uf1_basisw * (1-coalesce(p.rabatt,0)/100); -- Rabatt einrechnen
            p.aknr_referenz    := r.ld_bem;

            -- Hinweis zu eventuell vorhandenem fixierten Liefereanten
            IF Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) IS NOT null THEN
                p.status_enum := Tsystem.enum_setvalue( p.status_enum, Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) );
            END IF;

            -- Summme der Zuschläge holen, wenn es am Rahmen welche gibt
            SELECT SUM(coalesce(ldaz_betr*ldaz_anz,0)), COUNT(coalesce(ldaz_betr,0)) INTO abzubetrag, abzuanzahl
              FROM ldsabzu WHERE ldaz_ld_id = r.ld_id;

            p.hasAbzu          := abzuanzahl > 0;
            IF (p.hasAbzu) THEN
                -- Zuschlag pro GME der Bestellung
                p.abzubetrag_uf1_basisw := coalesce(abzubetrag,0) * p.kurs / Do1If0(r.ld_stk_uf1);
                -- Dann Positionsabzu (von ld_waer und ld_mce in uf1_basisw umgerechnet) reinrechnen (und auf Menge aufteilen)
                p.preis_uf1_basisw_abzu := p.preis_uf1_basisw_abzu + p.abzubetrag_uf1_basisw;
            END IF;

            -- Hinweis in Bezeichnung, wenn eigentlich nicht mehr genug Menge offen.Create_PreisME
            IF ( (p.menge / r.muf)  < coalesce(mengeGME,r.ld_eklos)) THEN
                p.source_bez :=
                                '!M! '
                                || IfThen( EKRahmenRestAbrufen, ', '
                                || lang_text(13564), '')
                                || ': '  || ROUND( coalesce(mengeGME,r.ld_eklos)  * r.muf, 2)::VARCHAR
                                || ' => ' || ROUND( p.menge * r.muf, 2)::VARCHAR
                                || ' ';

                                -- !M! Abruf reduziert: 10 => 5]
            END IF;
            p.source_bez := coalesce(p.source_bez,'') || lang_text(13086) || ': "' || r.rhl_nr||'"'; -- Rahmenvertrag R-Nummer
            p.IsValid:=true;
        -- Eingangsrechnungen
        ELSEIF lower(srcTable)  = 'belegpos' THEN -- TODO Klärung Eingrechpos?

            IF Current_User='root' THEN  RAISE NOTICE '----> RUN.TWawi.Create_Preis: From => belegpos'; END IF;

            SELECT belp_id, beld_dokunr, belp_pos, belp_aknr, belp_referenzaknr, belp_krzrechnung, belp_rabatt,
                   belp_preis_gme_basis_w,  belp_preis, belp_abzupreis_gme, belp_preiseinheit, belp_preis_gme,
                   belp_kurs, belp_mce, beld_waehr, belp_los, belp_menge, belp_menge_gme,
                   belp_erstelldatum, belp_erledigt, beld_refbeleg, steu_z, steu_proz,
                   belp_erstelldatum, eingrech_pos.insert_date,
                   eingrech_pos.dbrid, ak_los,
                   m_uf AS muf
              INTO r
              FROM eingrech_pos
                   JOIN art           ON belp_aknr = ak_nr
              LEFT JOIN artmgc        ON belp_aknr = m_ak_nr AND belp_mce = m_id
              LEFT JOIN eingrech      ON beld_id   = belp_dokument_id
              CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get(belp_steucode)

             WHERE eingrech_pos.dbrid = srcDBRID;

            p.preis            := r.belp_preis;
            p.preiseinheit     := r.belp_preiseinheit;
            p.preis_uf1        := r.belp_preis_gme;
            p.preis_uf1_basisw := r.belp_preis_gme_basis_w;

            -- Losgröße in Belegpos oft nicht gesetzt. Kommt ggf. aus ld_eklos, also Bestellung. Für Preissuche Fallback auf Artikelstamm-Losgröße.
            p.Los              := coalesce( r.belp_los, r.ak_los, 0 );

            -- Preisbezugs-Menge ist ERG-Menge. Wir suchen z.Bsp. gerade Preis für 4 Stk. die Rechnung zeigt aber einen Preis der für 200 Stk. galt. Das ist wichtig.
            p.Menge            := r.belp_menge;

            IF RoundToLos THEN

                -- Gewünschte Menge in Beleg-ME umgerechnet.Dann Losrundung wenn erforderlich.
                p.Menge_Los := TWawi.Round_ToLos( p.los, coalesce( MengeGME, 1) * r.muf );
            ELSE
                p.Menge_Los := coalesce( MengeGME, 1 ) * r.muf;
            END IF;

            --
            p.kurs             := coalesce( nullif( r.belp_kurs, 0 ), 1);
            p.ad_krz           := r.belp_krzrechnung;
            p.ak_nr            := r.belp_aknr;
            p.datum            := coalesce( r.belp_erstelldatum, r.insert_date );
            p.rabatt           := r.belp_rabatt;
            p.wacode           := r.beld_waehr;
            p.steucode         := r.steu_z;
            p.steuproz         := r.steu_proz;
            --
            p.source_bez       := lang_text(13789) || ' ' || r.beld_dokunr;
            p.source_table     := 'belegpos';
            p.source_dbrid     := r.dbrid;
            p.artmgcid         := r.belp_mce;
            p.aknr_referenz    := r.belp_referenzaknr;

            -- Hinweis zu eventuell vorhandenem fixierten Liefereanten
            IF Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) IS NOT null THEN
                p.status_enum := Tsystem.enum_setvalue( p.status_enum, Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) );
            END IF;

            --Summe der Zuschläge holen (nur Belegpositions-Zuschläge), Dokument-Zuschläge werden derzeit NICHT berücksichtigt.
            abzubetrag :=
                sum(
                    coalesce( belpaz_betrag, 0 )
                  * coalesce( belpaz_anzahl, 0 )
                )
                FROM belegposabzu
                WHERE belpaz_belegpos_id = r.belp_id
            ;
            p.hasAbzu          := abzubetrag IS NOT null; --coalesce( abzubetrag, 0 ) > 0; (Prozentuale)

            -- Das ist mit Zuschlägen UND Rabatten
            p.preis_uf1_basisw_abzu := r.belp_abzupreis_gme;


            IF p.hasAbzu THEN
                -- Währung rausrechnen und anteilig auf Menge der Belegposition.
                p.abzubetrag_uf1_basisw := coalesce( abzubetrag, 0 ) * p.kurs / Do1If0( r.belp_menge_gme );
            END IF;

            p.IsValid := true;

        -- Lieferantenangebote auf EK-Anfrage mit evtl. vorhandenen Angebotsstaffeln  -- Ergänzung zum Staffelpreis #12813 #13308
        ELSEIF lower( srcTable ) = 'anfangebot' OR lower( srcTable ) = 'anfangebotstaffel' THEN


            IF Current_User='root' THEN
                RAISE NOTICE '----> RUN.TWawi.Create_Preis: From => AnfAngebot';
            END IF;

            IF lower( srcTable ) = 'anfangebot' THEN
                detailDBRID := NULL;
            ELSIF lower( srcTable ) = 'anfangebotstaffel' THEN
                detailDBRID := srcDBRID;
                srcDBRID := anfangebot.dbrid FROM anfangebot, epreisstaffel WHERE est_aang_id = aang_id AND epreisstaffel.dbrid = detailDBRID;
            END IF;

            SELECT
                aang_id, anf_nr, aAng_preis, aang_preiseinheit, aang_menge, aLief_lkn, aart_ak_nr, aAng_datum, aang_bisdatum, aAng_Rabatt,
                steu_z, steu_proz, aAng_waer, aAng_akref, anfangebot.dbrid, alief_angnr,
                -- Ergänzung coalesce um m_uf #14883, freie Artikel
                -- aang_los aus aartlos übernommen -> evtl. null!!
                m_id,
                coalesce( m_uf, 1 ) AS muf,
                coalesce( aang_los, 1 ) as aang_los,
                -- Ergänzung zum Staffelpreis #12813 #13308
                epreisstaffel.*,
                coalesce( epreisstaffel.dbrid, anfangebot.dbrid ) AS pDBRID
            INTO r
            FROM anfAngebot
            JOIN anfArt                ON aAng_aArt_id = aArt_id
            JOIN anfLief               ON aLief_id = aAng_aLief_id
            JOIN anfrage               ON anf_nr = aArt_anf_nr
            LEFT JOIN art              ON aart_ak_nr = ak_nr
            LEFT JOIN mgcode           ON me_cod = aart_m_id
            LEFT JOIN artmgc           ON aart_ak_nr = m_ak_nr AND m_mgcode = me_cod
            -- Ergänzung zum Staffelpreis #12813 #13308
            LEFT JOIN epreisstaffel    ON est_aang_id = aang_id AND epreisstaffel.dbrid = detailDBRID -- OR detailDBRID IS null) -- gezielt eine staffel, oder ansonsten alle durchlaufen?
            CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get(aAng_steucode)

            WHERE
                 anfangebot.dbrid = srcDBRID
            ;

            -- Ergänzung zum Staffelpreis #12813 #13308
            p.preis                 := coalesce( r.est_ep, r.aAng_preis );                                                                 -- Preis wie angezeigt, mit Preiseinheit
            p.preis_uf1             := coalesce( p.preis * r.muf / Do1If0(r.aang_preiseinheit), 0 );
            -- Angebot immer in Eigenwährung, keine Umrechnung
            p.preis_uf1_basisw      := p.preis_uf1;
            p.preiseinheit          := coalesce( r.aang_preiseinheit, 1 );

            -- Los aus Angebot übernehmen statt wie bisher aus dem Artikel #14104
            p.los                   := r.aang_los;
            -- Menge aus Angebot übernehmen statt wie bisher aus dem Artikel #14783
            p.menge                 := r.aang_menge;

            IF RoundToLos THEN
                p.menge_los := TWawi.Round_ToLos( r.aAng_los, coalesce( MengeGME, 1 ) * r.muf );
            ELSE
                p.menge_los := coalesce( MengeGME, 1 ) * r.muf;
            END IF;

            p.ad_krz                := r.aLief_lkn;
            p.ak_nr                 := r.aart_ak_nr;
            p.datum                 := r.aAng_datum;
            p.datum_bis             := r.aang_bisdatum;

            p.rabatt             := coalesce( r.aAng_Rabatt, 0 );
            p.kurs               := coalesce( waerkurs( r.aAng_Waer ), 1 );
            p.wacode             := r.aAng_waer;
            p.artmgcid           := r.m_id;
            p.steucode           := r.steu_z;
            p.steuproz           := r.steu_proz;
            p.aknr_referenz      := r.aAng_akref;

            -- Hinweis zu eventuell vorhandenem fixierten Liefereanten
            IF Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) IS NOT null THEN
                p.status_enum := Tsystem.enum_setvalue( p.status_enum, Twawi.epreis__fixierter_lieferant__check( p.ak_nr ) );
            END IF;

            -- Unter Beachtung der Staffeln #12813 #13308
            IF r.est_aang_id IS NULL THEN
                -- Kein Staffelpreis
                p.source_bez       := lang_text( 13831 ) || ' ' || r.anf_nr  || ' ' || lang_text( 13832 ) || coalesce( r.aLief_angNr, '?' );
                p.source_table     := 'anfangebot';
                p.source_dbrid     := r.dbrid;
            ELSE
                -- Staffelpreis
                p.source_bez    :=  lang_text( 13831 ) || ' ' || r.anf_nr  || ' ' || lang_text( 13832 ) || coalesce( r.aLief_angNr, '?' ) ||
                                   ' [' || coalesce( r.est_mengevon, '0' ) || ' - ' || coalesce( r.est_mengebis::varchar, '...' ) || ']';
                p.source_table  := 'anfangebotstaffel';
                p.source_dbrid  := r.pdbrid;
                p.menge         := r.est_mengevon * r.muf ;
            END IF;

            -- Summe der Zuschläge an Angebotsposition
            abzubetrag :=
                sum(
                      coalesce( anfaz_anz, 0 )
                    * coalesce( anfaz_betr, 0 )
                )
                FROM anfabzu
                JOIN anfangebot ON anfaz_aang_id = aang_id
                WHERE aang_id = r.aang_id
            ;

            p.hasAbzu               := abzubetrag IS NOT null; -- abzubetrag > 0; auch leere Abzuschläge übernehmen!

            -- Anteilig aufteilen auf pro 1 GME
            abzubetrag := coalesce( abzubetrag  / ( r.aang_menge / r.muf ), 0 );
            -- Rabatt + Abzu einfrechnen
            p.preis_uf1_basisw_abzu := p.preis_uf1_basisw * ( 1 - coalesce( p.rabatt, 0 ) / 100 ) + abzubetrag;

            IF p.hasAbzu THEN
                -- Dann Positionsabzu pro ME, in Eigenwährung
                p.abzubetrag_uf1_basisw := coalesce( abzubetrag , 0 ) * p.kurs;
            END IF;

            p.IsValid := true;

        ELSE -- Kaputt, keine bekannte Source-Table
            RAISE EXCEPTION '% SrcTable=%', lang_text( 13565 ), srcTable; -- Ungültige Preisquelle. Parameter SrcTable ist von unbekanntem Typ.
        END IF;

        RETURN p;

    END $$ LANGUAGE plpgsql STABLE;



-- DROP FUNCTION IF EXISTS TWawi.Create_PreisMe(VARCHAR,VARCHAR,NUMERIC,INTEGER,BOOLEAN);
-- Erzeugt einen Preisdatensatz für die gewünschte Menge und ME aus der angegeben Preisquelle. Nur an einer Stelle benutzt. Ggf. raus oder wenigstens auf Language SQL umstellen?
CREATE OR REPLACE FUNCTION TWawi.Create_PreisME (
    IN srcTable   VARCHAR(40),         -- Quelltabelle
    IN srcDBRID   VARCHAR(32),
    IN menge      NUMERIC(12,4),       -- Menge in einer Mengeneinheit des Artikels
    IN me         INTEGER,             -- ArtMgcID der Artikel-Mengeneinheit
    IN RoundToLos BOOLEAN DEFAULT TRUE -- True, rundet auf Losgröße der Preisquelle auf
    )
    RETURNS TWawi.Preis
    AS $$
    DECLARE
    BEGIN
    RETURN TWawi.Change_ME(me,TWawi.Create_preis( srcTable, srcDBRID, tartikel.me__menge__in__menge_uf1(me, menge), RoundToLos));
    END $$ LANGUAGE plpgsql STABLE;
  --

--------------------- Preise suchen

    -- Sucht den Preis für einen Artikel in den angegebenen Preisquellen
    CREATE OR REPLACE FUNCTION TWawi.Search_EKPreis(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _fertaknr       varchar(50) DEFAULT '',
        IN _liefkrz        varchar(21) DEFAULT '%',
        -- SearchOptions = Kommaseparierte Liste von zu durchsuchenden Preisquellen. Der erste gefundene Preis wird zurückgegeben. Reihenfolge entspricht also der Such-Priorität.
        -- EKP_LDSDOK, EKP_EPREIS_E_STAL, EKP_EPREIS, EKP_ART_AK_HEST, EKP_ANFANGEBOT, EKP_EINGRECH
        IN _SearchOptions  varchar     DEFAULT TSystem.Settings__Get('EKPSources'),
        --
        IN _ShowHint       boolean     DEFAULT false,
        IN _checkArtNorm   boolean     DEFAULT true,
        IN _roundToLos     boolean     DEFAULT true,
        IN _maxPreisDatum  date        DEFAULT null,
        IN _PreisZeitpunkt date        DEFAULT current_date,   --  Lieferantenangebote Preisgültigkeit
        OUT preis TWawi.Preis
        )
        RETURNS TWawi.Preis
        AS $$
        DECLARE _hinttxt    varchar;
                _cPreis     TWawi.Preis;
                _preise     TWawi.Preis[];
                _r          record;
                i           integer;
        BEGIN
            -- IF Current_User='root' THEN  RAISE NOTICE '----> ENTER.TWawi.Search_EKPreis (%,%,%,%)',_aknr, _mengeuf1::varchar,_fertaknr,_liefkrz; END IF;

            -- Parameterprüfung, notwendig weil Default-Werte nicht greifen, wenn PGDac die Parameter explizit mit NULL gefüllt hat, statt sie einfach wegzulassen.
            IF (_aknr IS NULL) THEN
              RETURN;
            END IF;

            -- Preisquellen aus Parameter oder per Systemeinstellung
            _SearchOptions  := coalesce( NullIf(_SearchOptions,''), TSystem.Settings__Get('EKPSources'));
            -- Maximales Alter des Preises aus Parameter oder Systemeinstellung (Heute - [x * Jahre)
            _MaxPreisDatum  := coalesce(_maxPreisDatum, (current_date - 365 * TSystem.Settings__GetInteger('EKPMaxAlter')));
            --
            _mengeUf1       := coalesce(NullIf(_mengeUF1,0),1);    -- Bei Suche mit NULL oder0 => 1 suchen.
            _fertaknr       := NullIf(TRIM(_fertaknr),'');         -- Leerstring = NULL
            _liefkrz        := coalesce(NullIf(_liefkrz,''),'%');  -- Leerstring = NULL = % = Alle Lieferanten durchsuchen
            _showHint       := coalesce(_showHint      , true);
            _CheckArtNorm   := coalesce(_checkArtNorm  , true);
            _RoundToLos     := coalesce(_RoundToLos    , true);

            IF (_aknr IS NULL) OR (NullIf(_mengeUF1,0) IS NULL) THEN
              RETURN;
            END IF;

            FOR _r in SELECT TRIM(regexp_split_to_table(_SearchOptions,',')) AS source LOOP

              -- RAISE NOTICE 'TWawi.Search_EKPreis: Suche Preis aus Quelle "%"',_r.Source;
              _cPreis := NULL;

              CASE WHEN _r.source ILIKE 'EKP_LDSDOK' THEN
                        -- Als erstes ablaufende?, offene Rahmen
                        IF _fertaknr IS NULL THEN
                            _cPreis := TWawi.Search_EKRahmen(_aknr, _mengeuf1, _liefkrz, _RoundToLos);
                        END IF;
                   -- Stammlieferantenpreis (für Staffel)
                   WHEN _r.source ILIKE 'EKP_EPREIS_E_STAL' THEN
                        _cPreis := TWawi.Search_EPreis(_aknr, _mengeuf1, _fertaknr, _liefkrz, TRUE, _checkArtNorm, _RoundToLos ,_maxpreisdatum);
                   -- Günstigste Lieferantenpreis (für Staffel)
                   WHEN _r.source ILIKE 'EKP_EPREIS' THEN
                        _cPreis := TWawi.Search_EPreis(_aknr, _mengeuf1, _fertaknr, _liefkrz, false, _checkArtNorm, _RoundToLos, _maxpreisdatum);
                   -- Selbstkosten, wenn die > 0 sind. Andernfalls wurde da nie was eingetragen.
                   WHEN _r.source ILIKE 'EKP_ART_AK_HEST' THEN
                        IF _fertaknr IS NULL THEN
                            _cPreis := TWawi.Search_Selbstkosten(_aknr, _mengeuf1, _RoundToLos);
                            IF coalesce(_cPreis.preis,0) = 0 THEN
                                _cPreis := NULL;
                            END IF;
                        END IF;
                   -- Das günstigste Angebot der letzten Anfrage
                   WHEN _r.source ILIKE 'EKP_ANFANGEBOT' THEN
                           _cPreis := TWawi.Search_LiefAngebot_Preise(_aknr, _mengeUF1, _fertaknr, _liefkrz, _RoundToLos, 1, current_date - _maxPreisDatum, _PreisZeitpunkt);
                   -- Neueste Eingangsrechnung für Artikel
                   WHEN _r.source ILIKE 'EKP_EINGRECH' THEN
                            _cPreis := TWawi.Search_Eingrech_Preise(_aknr, _mengeUF1, _fertaknr, _liefkrz, _RoundToLos, 1, current_date - _maxPreisDatum);
                   WHEN TRIM(_r.source) = '' THEN --durch entfernen evtl überzähliges Komma
                        NULL;
              ELSE
                    RAISE EXCEPTION 'TODO: TWawi.Search_EKPreis %', Format(lang_text(20151) /*'TODO: TWawi.Search_EKPreis Meldung + Logeintrag KAPUTT wg. falscher Preisquelle. _SearchOptions: %, Option: %, _Fertaknr: %'*/, _SearchOptions, _r.source, _fertaknr);
              END CASE;

              -- Gültigen Preis gefunden, dann geben wir den zurück.
              IF (NOT _cPreis IS NULL) AND coalesce(_cPreis.IsValid,FALSE) AND (preis IS NULL) THEN
                  -- RAISE NOTICE 'TWawi.Search_EKPreis: Gültiger Preis gefunden in Quelle "%" -> % ', _r.Source, _cPreis;
                  preis  := _cPreis;
                  _preise := Array_Append(_preise,preis);
              END IF;

            END LOOP;

            IF _ShowHint THEN
              _Hinttxt:=lang_text(13078)||' "'||_aknr||'" ('|| _mengeUF1::VARCHAR || ' ' || standardmgc_iso(_aknr)||')';  -- Suche _Preise für Artikel XYZ (100 Stk)
              FOR i IN array_lower(_preise, 1) .. array_upper(_preise, 1) LOOP
                IF _preise[i].IsValid THEN
                  _hinttxt:= _hinttxt || E'\r\n' || IFTHEN((_preise[i].source_dbrid = preis.source_dbrid), '->', '  ') || TWawi.As_DisplayText(_preise[i]);
                END IF;
              END LOOP;
              PERFORM Prodat_hint(_hinttxt);
            END IF;

            preis.minPreis:=(TWawi.Min_preis(_preise)).preis_uf1_basisw_abzu;  -- Kleinsten Preis merken zum zurückgeben
            preis.maxPreis:=(TWawi.Max_preis(_preise)).preis_uf1_basisw_abzu;  -- Höchsten Preis merken zum zurückgeben

            -- Gezielte Suche nach Lieferant, es wurde aber nur ein Selbskosteneintrag gefunden. Wenn Lieferant reingegeben wurde, werden wie da wahrscheinlich bestellen.
            -- Also Preisdaten mit Lieferantendaten abgleichen, damit das zusammen passt.
            IF (_liefkrz <> '%') AND (preis.source_table = 'art') THEN

              SELECT a2_krz, a2_waco, steu_z AS sCode, steu_proz AS sProz INTO _r
                FROM adk2
                CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get( coalesce(a2_wuco, TSystem.Settings__GetInteger('einksteucode')) )
                WHERE a2_krz LIKE _liefkrz;

              IF _r.a2_waco IS NULL THEN -- Keine Kreditorendaten angelegt - sonst hätten wir eine Währung
                RETURN;
              END IF;

              preis.ad_krz   := _r.a2_krz;
              preis.steucode := _r.sCode; -- Steuercode aus Adk2
              preis.steuproz := _r.sProz; -- Prozentsatz zum Steuercode
              -- Umrechnung auf Lieferantenwährung aus Adk2 mit aktuellem Bewa-Kurs
              IF _r.a2_waco IS DISTINCT FROM preis.wacode THEN
                preis := TWawi.Change_Waehrung(_r.a2_waco, NULL, preis);
              END IF;
            END IF;

            RETURN;
        END $$ LANGUAGE plpgsql STABLE;
  --

    -- Gibt für jede Preisquelle den entsprechenden Preis zurück, falls einer gefunden wird. => Übersicht der Preise zu einem Artikel
    CREATE OR REPLACE FUNCTION TWawi.Search_EKPreise(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _fertaknr       varchar(50) DEFAULT '',
        IN _liefkrz        varchar(21) DEFAULT '%',
        -- SearchOptions = Kommaseparierte Liste von zu durchsuchenden Preisquellen. Der erste gefundene Preis wird zurückgegeben. Reihenfolge entspricht also der Such-Priorität.
        -- EKP_LDSDOK, EKP_EPREIS_E_STAL, EKP_EPREIS, EKP_ART_AK_HEST, EKP_ANFANGEBOT, EKP_EINGRECH
        IN _SearchOptions  varchar DEFAULT TSystem.Settings__Get('EKPSources'),
        --
        IN _checkArtNorm   boolean DEFAULT true,
        IN _roundToLos     boolean DEFAULT true,
        IN _maxPreisDatum  date    DEFAULT null,
        IN _PreisZeitpunkt date    DEFAULT current_date,   --  Lieferantenangebote Preisgültigkeit
        OUT preis          TWawi.Preis
        )
        RETURNS SETOF TWawi.Preis
        AS $$
        DECLARE _hinttxt    varchar;
            _preise        TWawi.Preis[];
            _tmp           TWawi.Preis[];
            _p             TWawi.Preis;
            _r             record;
            i              integer;
            j              integer;
            _minPreis      numeric;
            _maxPreis      numeric;
            _dbrids         varchar[];
        BEGIN
            IF current_user='root' THEN  RAISE NOTICE '----> ENTER.TWawi.Search_EKPreise (%,%,%,%)',_aknr, _mengeuf1::varchar,_fertaknr,_liefkrz; END IF;

            -- Preisquellen aus Parameter oder per Systemeinstellung
            _SearchOptions  := coalesce( NullIf(_SearchOptions,''), TSystem.Settings__Get('EKPSources'));
            -- Maximales Alter des Preises aus Parameter oder Systemeinstellung (Heute - [x * Jahre)
            _MaxPreisDatum  := coalesce(_maxPreisDatum, (current_date - 365 * TSystem.Settings__GetInteger('EKPMaxAlter')));
            --

            -- Parameterprüfung, notwendig weil Default-Werte nicht greifen, wenn PGDac die Parameter explizit mit NULL gefüllt hat, statt sie einfach wegzulassen.
            IF (_aknr IS NULL) THEN RETURN; END IF;

            _mengeUf1       := NullIf(_mengeUF1, 0);               -- Bei Suche mit NULL oder 0 => alle Mengen anzeigen
            _fertaknr       := NullIf(Trim(_fertaknr),'');         -- Leerstring = NULL
            _liefkrz        := coalesce(NullIf(_liefkrz,''),'%');  -- Leerstring = NULL = %
            _CheckArtNorm   := coalesce(_checkArtNorm  , true);
            _RoundToLos     := coalesce(_RoundToLos    , true);
            --
            FOR _r in SELECT TRIM(regexp_split_to_table(_SearchOptions,',')) AS source LOOP

              -- RAISE NOTICE 'TWawi.Search_EKPreis: Suche Preis aus Quelle "%"',_r.Source;
              _tmp := NULL;
              _p   := NULL;

              CASE WHEN _r.source ILIKE 'EKP_LDSDOK' THEN

                        IF _fertaknr IS NULL THEN
                               -- Alle zutreffenden Rahmenverträge raussuchen, aber nur wenn kein Arbeitspaket angegeben wurde
                             _tmp := array_agg(pl) FROM TWawi.Search_EKRahmen_List(_aknr, _mengeuf1, _liefkrz, _RoundToLos, FALSE) AS pl WHERE pl.IsValid;
                             _preise := array_cat( _preise, _tmp);
                        END IF;

                   -- Stammlieferantenpreis (für Staffel)
                   WHEN _r.source ILIKE 'EKP_EPREIS_E_STAL' THEN
                        _p := pl FROM TWawi.Search_EPreis(_aknr, _mengeuf1, _fertaknr, _liefkrz, TRUE, _checkArtNorm, _RoundToLos, _maxpreisdatum) AS pl WHERE pl.IsValid;
                        IF NOT (_p IS NULL OR _p.IsValid IS NULL) THEN
                          _preise := array_append( _preise, _p);
                        END IF;

                   -- Günstigste Lieferantenpreis (für Staffel)
                   WHEN _r.source ILIKE 'EKP_EPREIS' THEN
                        _tmp := array_agg(pl) FROM TWawi.Search_EPreis_List(_aknr, _mengeuf1, _fertaknr, _liefkrz, FALSE, _checkArtNorm, _RoundToLos, _maxpreisdatum, FALSE) AS pl WHERE pl.IsValid;
                        _preise := array_cat( _preise, _tmp);

                   -- Selbstkosten, wenn die > 0 sind
                   WHEN _r.source ILIKE 'EKP_ART_AK_HEST' THEN
                        IF _fertaknr IS NULL THEN
                             _p := pl FROM TWawi.Search_Selbstkosten(_aknr, _mengeuf1, _RoundToLos) AS pl WHERE pl.IsValid AND pl.preis > 0;
                            IF (NOT _p IS NULL) THEN
                                 _preise := array_append( _preise, _p);
                            END IF;
                        END IF;

                   -- Lieferantenangebote: Letzte Anfragen zuerst, sortiert nach günstigsten Angebot (Anzahl = NULL -> Default 5 Stück)
                   WHEN _r.source ILIKE 'EKP_ANFANGEBOT' THEN
                        _tmp := array_agg(pl) FROM TWawi.Search_LiefAngebot_Preise(_aknr, _mengeUF1, _fertaknr, _liefkrz, _RoundToLos, NULL, current_date - _maxPreisDatum, _PreisZeitpunkt) AS pl WHERE pl.IsValid;
                        _preise := array_cat( _preise, _tmp);

                   -- Neueste Eingangsrechnungen für Artikel (Anzahl = NULL -> Default 5 Stück)
                   WHEN _r.source ILIKE 'EKP_EINGRECH' THEN
                        _tmp := array_agg(pl) FROM  TWawi.Search_Eingrech_Preise(_aknr, _mengeUF1, _fertaknr, _liefkrz, _RoundToLos, NULL, current_date - _maxPreisDatum) AS pl WHERE pl.IsValid;
                        _preise := array_cat( _preise, _tmp);

                   WHEN TRIM(_r.source) = '' THEN --durch entfernen evtl überzähliges Komma
                        NULL;
                   ELSE
                        RAISE EXCEPTION 'TODO: TWawi.Search_EKPreis %', Format(lang_text(29151) /*'TODO: TWawi.Search_EKPreis Meldung + Logeintrag KAPUTT wg. falscher Preisquelle. _SearchOptions: %, Option: %, _Fertaknr: %'*/, _SearchOptions, _r.source, _fertaknr);
              END CASE;

            END LOOP;

            -- Dopplungen rauswerfen. Entstehen beispielsweise wenn Stammlieferant und Lieferanten (allgemein) als Quelle angegeben werden.
            -- Der Datensatz vom Stammlieferant ist dann in beiden Ergebnismengen enthalten.
            -- FUNKTIONIERT NICHT, da Sortierung dann hinüber ist: _preise := array_agg(DISTINCT dp) FROM Unnest(_preise) AS dp;

            IF NOT _preise[1] IS NULL THEN
               _dbrids := NULL;
               _minPreis:=(TWawi.Min_preis(_preise)).preis_uf1_basisw_abzu;
               _maxPreis:=(TWawi.Max_preis(_preise)).preis_uf1_basisw_abzu;

               -- Über alle gefundenen _Preise laufen, letzte Prüfungen (z.Bsp. auf Doppelungen) und ggf. ausgeben
               FOR i IN array_lower(_preise, 1) .. array_upper(_preise, 1) LOOP
                   preis:=_preise[i];
                   -- RAISE NOTICE 'I: %, _Dbrids: %', i, _dbrids;
                   -- Prüfen ob wir einen Preis mit der DBRID schonmal hatten und ggf. rausfischen.
                   IF (_dbrids IS NULL OR NOT (_dbrids @> ARRAY[preis.source_dbrid])) AND (NOT preis IS NULL) AND (preis.IsValid) THEN
                       _dbrids := array_append(_dbrids,preis.source_dbrid);
                       preis.minPreis := _minPreis; -- Kleinsten Preis merken zum zurückgeben
                       preis.maxPreis := _maxPreis; -- Höchsten Preis merken zum zurückgeben
                       RETURN NEXT;
                   END IF;
               END LOOP;
            END IF;

        END $$ LANGUAGE plpgsql STABLE;
  --

    --Sucht in Rahmenverträgen nach einem Preis und gibt den zuerst auslaufenden, nicht beendeten Rahmen zurück
    CREATE OR REPLACE FUNCTION TWawi.Search_EKRahmen(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _liefkrz        varchar(21) DEFAULT '%',
        IN _RoundToLos     boolean DEFAULT true
        )
        RETURNS TWawi.Preis
        AS $$
        DECLARE _p              TWawi.Preis;
        BEGIN
            SELECT * INTO _p FROM TWawi.Search_EKRahmen_List(_aknr, _mengeuf1, _liefkrz, _RoundToLos, true) LIMIT 1;
            RETURN _p;
        END $$ LANGUAGE plpgsql STABLE;
  --

    --Sucht in Rahmenverträgen nach einem Preis und gibt alle passenden oder nur den zuerst auslaufenden, nicht beendeten Rahmen zurück (Flag: bestPreisOnly = true => Nur älterster)
    CREATE OR REPLACE FUNCTION TWawi.Search_EKRahmen_List(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _liefkrz        varchar(21) DEFAULT '%',
        IN _RoundToLos     boolean DEFAULT true,
        IN _bestPreisOnly  boolean DEFAULT false,
        OUT preis         TWAWI.Preis
        )
        RETURNS SETOF TWawi.Preis
        AS $$
        DECLARE _p                    TWawi.Preis;
                _rec                  RECORD;
                _EKRahmenNachAblauf   BOOLEAN;     -- Ende Termin des Rahmens ignorieren und trotzdem vorschlagen, wenn noch Menge offen ist.
                _AuslaufAknr          VARCHAR(40); -- Ablaufender Artikel
        BEGIN

            /* Anmerkungen:
              1. NORM-PRÜFUNG entfällt, wir gehen davon aus, das ein Lieferant die Norm erfüllen kann, sonst gäbe es keinen Rahmenvertrag. Die Rahmendaten nehmen wir direkt aus ldsdok.
              2. Systemeinstellung Einkauf - 'Rahmenabrufe: Nach Ablauf vorschlagen' (_EKRahmenNachAblauf) steuert, ob ein Rahmen mit Erreichen des Ende-Termins ungültig wird oder nicht.
                            Hier implementiert, da das die Suchergebnisse beeinflusst.
              3. Systemeinstellung Einkauf - 'Rahmenabrufe: Bestellmenge auf Restmenge reduzieren' (EKRahmenRestAbrufen), ist _mengeUF1 > Offene Restmenge des Rahmens, wird diese reduziert und Losgröße 1 gesetzt
                            - In Create_Preis(table, dbrid) implementiert, da das immer gelten soll.
            */

            _EKRahmenNachAblauf  := coalesce( TSystem.Settings__GetBool('EKRahmenNachAblauf' ), false);

            -- Sollte der gesuchte Artikel ein Ersatzartikel für einen älteren sein (z.Bsp. aus einer Indexänderung),
            -- wollen wir Rahmen für den auslaufenden Artikel mit anzeigen, da wir die wahrscheinlich noch abrufen können,
            -- wenn der Lieferant das mitgeteilt bekommt. siehe: http://redmine.prodat-sql.de/issues/6083
            -- SELECT ak_nr INTO _AuslaufAknr FROM art WHERE ak_ersatzaknr = _aknr ORDER BY ak_nr LIMIT 1;
            -- Rausgenommen, die Suche nach Ersatzartikel-Nummer soll wahrscheinlich wieder raus.
            _AuslaufAknr:='';

            FOR _rec IN
              SELECT ldsdok.dbrid, ld_aknr
                FROM ldsdok
               WHERE (NOT ld_done)                                                -- Nicht abgeschlossener
                 AND (ld_code = 'R' OR ld_pos = 0)                                -- ... Rahmenvertrag
                 AND (ld_stkl < ld_stk_uf1)                                       -- ... mit offener Restmenge
                 AND ((ld_aknr = _aknr) OR ( ld_aknr = coalesce(_AuslaufAknr,'')))  -- ... für den Artikel oder den, den dieser Artikel ersetzt
                 AND (_liefkrz  IS NULL OR ( ld_kn LIKE _liefkrz))                  -- ... bei dem gewünschten (oder irgendeinem) Lieferant
                 --#13073 Zukünftige Rahmen werden sonst nicht gefunden!
                 --AND   (coalesce(ld_term  , termweek_to_date(ld_termweek, TRUE ) , current_date) <= current_date)                        -- ... Wenn Anfangsdatum vorhanden, dann muss das erreicht sein (True => 1. Wochentag nehmen).
                 AND  ((coalesce(ld_terml , termweek_to_date(ld_termweekl, false), current_date) >= current_date) Or _EKRahmenNachAblauf) -- ... Wenn Ende-Datum vorhanden, dann darf das noch nicht erreicht sein
               ORDER BY coalesce(ld_terml , termweek_to_date(ld_termweekl, false)), -- Zuerst ablaufend ...
                        coalesce(ld_term  , termweek_to_date(ld_termweek, true )), -- ... dann zuerst beginnend ...
                        ld_datum                                                   -- ... zuletzt den als erstes erfassten.
            LOOP --Über alle gefundenen Rahmen laufen und einen Preis für die Rahmendaten zusammenbauen

              -- Erstellt aus dem Ldsdok-Datensatz ein Preisobjekt. Macht Losrundung, Abrufreduzierung auf Restmenge, Abzu einrechnen
              _p:=TWawi.Create_Preis('ldsdok', _rec.dbrid, _mengeUF1, _RoundToLos);

              -- Das ist ein anderer Artikel? Muss ein Auslaufartikel sein und der gesuchte Artikel ist Ersatzartikel.
              IF (_rec.ld_aknr <> _aknr) THEN

                _p.source_bez := '!A! ' || lang_text(6129) || ' ' || _rec.ld_aknr || ', ' || _p.source_bez; --  !A! Auslaufartikel ARTXYZ, Rahmen: R2014-XYZ/1 ...

                -- Wir wollen nicht den Auslaufartikel im Preis haben, sondern den gesuchten. Der Auslaufartikel steht ja schon im source_bez Text mit.
                _p.ak_nr     := _aknr;
                -- Als Abrufmengeneinheit benötigen wir die gleiche ME, aber mit artmgcid des neuen Artikels
                -- Mit FALSE gibt es keinen Fallback auf die Standard-ME, das bleibt also leer, wenn die ME des Rahmens im
                -- neuen Artikel nicht definiert ist.
                _p.artmgcid  := TArtikel.me__convertme_for_art__by__mid(_aknr, _p.artmgcid, false);
              END IF;

              preis := NULL;
              IF _p.IsValid THEN
                 preis := _p;
                 RETURN NEXT;
              END IF;


              --Wir wollen nicht alle Rahmen, sondern nur einen (den zuerst auslaufenden) wofür das Order BY im SELECT gesorgt hat.
              IF _bestPreisOnly THEN
                 EXIT;
              END IF;

            END LOOP;

        END $$ LANGUAGE plpgsql STABLE;
  --

    -- Besten Lieferantendaten-Preis suchen
    CREATE OR REPLACE FUNCTION TWawi.Search_EPreis(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _fertaknr       varchar(50)   DEFAULT null,
        IN _liefkrz        varchar(21)   DEFAULT '%',
        IN _checkStammLief boolean       DEFAULT false,
        IN _checkArtNorm   boolean       DEFAULT true,
        IN _roundToLos     boolean       DEFAULT true,
        IN _maxPreisDatum  DATE          DEFAULT null
        )
        RETURNS TWawi.Preis
        AS $$
        DECLARE p TWawi.Preis;
        BEGIN
            -- Maximales Alter des Preises aus Parameter oder Systemeinstellung (Heute - [x * Jahre)
            _MaxPreisDatum  := coalesce(_maxPreisDatum, (current_date - 365 * TSystem.Settings__GetInteger('EKPMaxAlter')));
            --
            SELECT * INTO p FROM TWawi.Search_EPreis_List(_aknr, _mengeuf1, _fertaknr, _liefkrz, _checkStammLief, _checkArtNorm, _roundToLos, _maxPreisDatum, true) LIMIT 1;
            IF coalesce(p.IsValid, false) THEN
                RETURN p;
            ELSE
                RETURN NULL;
            END IF;
        END $$ LANGUAGE plpgsql STABLE;
  --

    -- Sucht in den Lieferantenpreisen nach den gültigen Preis eines Artikels. Wahlweise wird nur der beste Preis zurückgegeben.
    CREATE OR REPLACE FUNCTION TWawi.Search_EPreis_List(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _fertaknr       varchar(50)    DEFAULT NULL,
        IN _liefkrz        varchar(21)    DEFAULT '%',
        IN _checkStammLief boolean        DEFAULT FALSE,
        IN _checkArtNorm   boolean        DEFAULT true,
        IN _roundToLos     boolean        DEFAULT true,
        IN _maxPreisDatum  date           DEFAULT NULL,
        IN _bestPreisOnly  boolean        DEFAULT FALSE,
        OUT preis         TWAWI.Preis
        )
        RETURNS SETOF TWawi.Preis
        AS $$
        DECLARE
            _p              TWawi.Preis;
            _ep_uf1bw       numeric;
            _ep_uf1bwabz    numeric;
            _rec            record;
            _azrec          record;
            _mlos           numeric;
            _abzubetrag     numeric;
            _bestpreistable varchar(40);
            _bestpreisdbrid varchar(32);
            _bestpreis      numeric;
        BEGIN
            _bestpreis      := 999999999; --Schlechter Code - funktioniert nur, wenn keiner unserer Kunden Flugzeugträger kauft. Die haben größere Stückpreise als 1 Milliarde!
            _bestpreistable := NULL;
            _bestpreisdbrid := NULL;

            -- Maximales Alter des Preises aus Parameter oder Systemeinstellung (Heute - [x * Jahre)
            _MaxPreisDatum  := coalesce(_maxPreisDatum, (current_date - 365 * TSystem.Settings__GetInteger('EKPMaxAlter')));
            --
            FOR _rec IN (
              SELECT -- Zählen, wie oft der gleiche Epreis-Satz auftaucht, wichtig wegen Staffelüberschneidung
                     row_number() OVER (PARTITION BY e_id ORDER BY coalesce(est_mengevon, 0) DESC) AS liefcount,
                     epreis.*, est_e_id, est_ep, m_uf,
                     epreis.dbrid        AS epDBRID,
                     epreisstaffel.dbrid AS estDBRID,
                     est_mengevon, est_mengebis
                FROM epreis LEFT JOIN epreisstaffel ON est_e_id = e_id
                LEFT JOIN artmgc        ON e_mcv = m_id
               WHERE e_aknr = _aknr  -- Artikelnummer oder Arbeitspaket, das ist immer gefüllt.
                 --AND (coalesce(e_lkn,'') <> '#')                                                -- Keine intern gesammelten Preise (z.Bsp. aus NK auf ABKs)
                 AND (coalesce(e_herkunft,'') NOT LIKE 'ER =%' OR e_stal)                       -- Controlling-Datensätze ausschließen (Rückgg. Eingangsrechnungen), außer es ist Stammlieferant
                 AND (e_fertaknr LIKE _fertaknr OR e_fertaknr IS NULL )                          -- Wenn e_aknr = Arbeitspaket, dann steht hier die Fert.Artikelnummer ...
                 AND (_liefkrz  IS NULL   OR (e_lkn      LIKE _liefkrz))                          -- Lieferant kann eingeschränkt oder beliebig sein
                 AND (e_bisdatum IS NULL OR (e_bisdatum >= current_date))                       -- Gültigkeit-Bis-datum noch nicht überschritten
                 AND coalesce(e_gdatum, epreis.insert_date, _maxPreisDatum) >= _maxPreisDatum     -- Preisdatum Nicht älter als _MaxPreisdatum (oder nicht angegeben)
                 AND IfThen(_checkStammLief, e_stal, TRUE)
                 -- Auf Los gerundete Menge ausrechnen mit e_stk als Losgröße. Ist in ME des Records.
                 -- runden nur wenn _roundtolos true 12355 NEG
                 AND (   (est_id IS null)
                      OR (_mengeUF1 IS null)
                      OR (ifThen(_roundtolos, TWawi.Round_ToLos(coalesce(e_stk, 1), _mengeUF1 * m_uf), _mengeUF1 * m_uf) BETWEEN coalesce(est_mengevon, 0 ) AND coalesce(est_mengebis, 99999999999999))
                      )
                 AND true                                                             -- Normprüfung einbauen. Norm von außen reingeben, damit die aus Auftrag weitergegeben werden kann
                 --AND IfThen(_checkArtNorm, TAdk.Check_EKNorm(_aknr,''::varchar),TRUE) -- Neue Function zur Normprüfung des Lieferanten benutzen TAdk.Check_EkZert('NORM,AL-ZER','DIN-Blabla');
                 -- Zuerst Stammlieferantenpreis. Innerhalb eines Lieferanten nach bestem Preis (Staffel 0..25 | 25..50 -> Günstigere)
               ORDER BY e_stal DESC, coalesce(e_ep_uf1_basis_w_abzu, 0)
              ) -- Ende Select
            LOOP

              --Auf Los gerundete Menge ausrechnen mit e_stk als Losgröße. Ist in ME des Records.
              -- runden nur wenn _roundtolos true 12355 NEG
              _mlos := ifThen(_roundtolos, TWawi.Round_ToLos(coalesce(_rec.e_stk, 0), _mengeUF1 * _rec.m_uf), _mengeUF1 * _rec.m_uf);

              -- RAISE NOTICE 'NEU: - % % Counter: % Menge: %', _rec.e_id, _rec.e_lkn, _rec.liefcount,  coalesce(_rec.est_mengevon,0);

              IF (NOT _bestPreisOnly)  THEN
                -- Wir wollen mehrere  Treffer ausgeben. Prüfen ob das erste Datensatz mit der e_id ist. Pro Epreis-Datensatz wollen wir nur einmal was ausgeben,
                -- das Query trifft aber bei Staffeln 0..25 und 25..50 zwei Sätze für die Menge. Den zweiten ignorieren wir.
                IF (_rec.liefcount <> 1 ) THEN
                  -- RAISE NOTICE 'RAUS: - % % Counter: % Menge: %', _rec.e_id, _rec.e_lkn, _rec.liefcount,  coalesce(_rec.est_mengevon,0);
                  CONTINUE;
                END IF;

                IF _rec.est_e_id IS NULL THEN -- Epreis-Satz
                  _p := TWawi.Create_Preis( 'epreis'       , _rec.epDBRID , _mengeUF1, _RoundToLos ); -- _MengeUF1 reingeben, das wird beim Erstellen nochmal umgerechnet und gerundet
                ELSE
                  _p := TWawi.Create_Preis( 'epreisstaffel', _rec.estDBRID, _mengeUF1, _RoundToLos );
                END IF;

                -- RAISE NOTICE 'GENOMMEN: - % % Counter: % Menge: %', _rec.e_id, _rec.e_lkn, _rec.liefcount,  coalesce(_rec.est_mengevon,0);

                IF _p.IsValid THEN
                   preis := _p;
                   RETURN NEXT;
                END IF;
              END IF;

              -- RAISE NOTICE 'WEITER - % % Counter: % Menge: %', _rec.e_id, _rec.e_lkn, _rec.liefcount,  coalesce(_rec.est_mengevon,0);

              -- Wenn wir nur den passendsten Treffer wollen, müssen wir anfangen rumzurechnen
              IF _bestPreisOnly THEN

                IF _rec.est_e_id IS NULL THEN
                  _ep_uf1bw := _rec.e_ep_uf1_basis_w; -- Keine Staffel
                ELSE
                  _ep_uf1bw := _rec.est_ep * _rec.m_uf * coalesce(_rec.e_kurs, 1); -- Staffelpreis...
                  _ep_uf1bw := _ep_uf1bw / Do1If0(_rec.e_preiseinheit);          -- Preiseinheit muss rausgerechnet werden, da der Preis analog epreis.e_preis den 'Anzeigebetrag' enthält.
                END IF;

                _Abzubetrag:=0;
                -- Über alle Abzuschläge der Position laufen
                FOR _azRec IN SELECT eaz_betr, eaz_anz, eaz_proz, eaz_type FROM epreisabzu WHERE eaz_e_id = _rec.e_id LOOP

                  IF coalesce(_azRec.eaz_proz,0) > 0 THEN
                    -- Prozentual Zuschlag => Rabattierten Positionswert nehmen => Prozentualer Abzuschlag. Ist unabhängig von Mengen u. ME, da Preisbezogen.
                    _Abzubetrag:= _Abzubetrag + (_ep_uf1bw * (1 - coalesce(_rec.e_rab,0) / 100) * (1 - coalesce(_azRec.eaz_proz,0) / 100));
                  ELSE
                    -- Abzuschläge, Betrag * Anzahl der Abzuschläge, runtergebrochen auf Betrag pro Stück in UF1. UF1 notwendig, damit Preise weiterhin vergleichbar.
                    -- (PHKO, DG) Definition Fall mengeGME unter 1: Anteil der AbZu ist dann * Mindermenge (quasi Bestellmenge mind. 1 GME und dann den Anteil davon)
                    -- mit / Mindermenge geht Preis gegen Unendl. (als ob die Mindermenge mit jeweiligen Zuschlag bis zu 1 GME n-fach bestellt werden würde).
                    -- ALT!!!     _abzubetrag:= _abzubetrag + (coalesce(_azrec.eaz_betr,0) * coalesce(_azrec.eaz_anz,0) * CASE WHEN _mlos < 1 THEN _mlos ELSE 1 / _mlos END);
                    IF _azrec.eaz_type = 'E' THEN
                      -- einmalig pro VOrgang
                      _abzubetrag := _abzubetrag + _azrec.eaz_betr / ifthen(_mengeUF1 * _rec.m_uf < _rec.e_stk, _rec.e_stk, _mengeUF1 * _rec.m_uf);
                    ELSE
                      _abzubetrag := _abzubetrag + _azrec.eaz_betr; --#13120 runtergebrochen auf Menge pro STK in UF1! -> damit hier nicht mit Menge multiplizieren!
                    END IF;
                  END IF;
                END LOOP;

                -- Rabatt + Abzu pro ME als "Endpreis"
                _ep_uf1bwabz := _ep_uf1bw * (1 - coalesce(_rec.e_rab, 0) / 100) + _abzubetrag*coalesce(_rec.e_kurs, 1);

                -- Ist der Preis besser als der letzte? Dann merken wir uns den zum zurückgeben, wenn alle durchgerechnet wurden.
                IF (_ep_uf1bwabz >= 0) AND (_ep_uf1bwabz < _bestpreis) THEN
                  _bestpreis      := _ep_uf1bwabz;
                  IF _rec.est_e_id IS NULL THEN
                    _bestpreistable := 'epreis';
                  ELSE
                    _bestpreistable := 'epreisstaffel';
                  END IF;
                  _bestpreisdbrid := coalesce(_rec.estDBRID,_rec.epDBRID);
                END IF;
              END IF;
            END LOOP;

            IF _bestPreisOnly THEN --Wir sollen nur den besten Preis zurückgeben. Das machen wir jetzt.

              preis := NULL;
              IF _bestpreisdbrid IS NOT NULL THEN
                _p := TWawi.Create_Preis(_bestpreistable, _bestpreisdbrid, _mengeUF1, _RoundToLos);
                IF _p.IsValid THEN
                  preis := _p;
                END IF;
              END IF;

              RETURN NEXT;

            END IF;

        END $$ LANGUAGE plpgsql STABLE;
  --


    -- Sucht in den Eingangsrechnungen nach Preisen eines Artikels. Wahlweise wird nur der aktuellste Preis zurückgegeben.
    CREATE OR REPLACE FUNCTION TWawi.Search_Eingrech_Preise (
        IN _aknr           varchar(50),                -- Artikelnummer. Ausnahme: Bei Auswärtsbearbeitung ist dass das Arbeitspaket.
        IN _mengeUF1       numeric(12,4),              -- Gewünschte Menge ...
        IN _fertaknr       varchar(50)   DEFAULT NULL, -- Fertigungsartikel, wenn bei _aknr ein Arbeitspaket angegeben wurde.
        IN _liefkrz        varchar(21)   DEFAULT '%',  -- Lieferanteneinschränkung, im Standard alle.
        IN _RoundToLos     boolean DEFAULT TRUE,       -- Losrundung aktivieren
        IN _LimitRows      integer DEFAULT 5,          -- Maximal soviele Datensätze / Preise zurückgeben ... sortiert nach Alter aufsteigend
        IN _LimitAge       integer DEFAULT 365  * TSystem.Settings__GetInteger('EKPMaxAlter'),        -- Maximales Alter des Preises in Tagen
        OUT preis         TWAWI.Preis
        )
        RETURNS SETOF TWawi.Preis
        AS $$
        DECLARE _p              TWawi.Preis;
                _rec            record;
                _fAknr          varchar;
        BEGIN
          --
          _LimitRows := coalesce(_LimitRows,5);
          _LimitAge  := coalesce(_LimitAge, 365  * TSystem.Settings__GetInteger('EKPMaxAlter'));
          --
          _fAknr := _FertAknr; -- sonst ist das Feld in der Abfrage ambiguous
          FOR _rec IN (
              SELECT * FROM (
                 SELECT
                   row_number() OVER (ORDER BY  beld_erstelldatum DESC ) as rows,  -- ANALOG Order By Klausel halten.
                   eingrech_pos.dbrid
                 FROM eingrech_pos
                   JOIN eingrech ON belp_dokument_id = beld_id
                   LEFT JOIN artmgc   ON belp_mce = m_id
                   LEFT JOIN LATERAL (SELECT * FROM  tabk.abk__fertdata__by__a2_id(belp_a2_id)) AS AwData ON belp_a2_id IS NOT NULL
                 WHERE belp_belegtyp = 'ERG'
                   AND (belp_aknr = _aknr)
                   AND (_fAknr IS NULL OR AwData.FertAknr  LIKE _fAknr)     -- Auswärtsbearbeitung: Fertigungsartikel einschränken, wenn der angegeben wurde
                   AND (_LiefKrz         IS NULL OR belp_krzrechnung LIKE _LiefKrz )  -- Lieferant kann eingeschränkt oder beliebig sein
                   AND (beld_erstelldatum > (current_date - _LimitAge))              --
                 ORDER BY beld_erstelldatum DESC
                ) as sq1  --  Mengen ? Normprüfung erforderlich ? -> TAdk.Check_EKNorm(_aknr,''::varchar),TRUE)
               WHERE (rows <= _LimitRows))
          LOOP
             -- TODO klärung -- TODO Klärung Eingrechpos?
             _p := TWawi.Create_Preis( 'belegpos', _rec.dbrid, _mengeuf1, _RoundToLos ); -- _MengeUF1 ? Eingangsrechnung war über 12 Stk, wir wollen aber 200 kaufen?!
             IF _p.IsValid THEN
                preis:=_p;
                RETURN NEXT;
             END IF;
          END LOOP;

          RETURN;

        END $$ LANGUAGE plpgsql STABLE;
  --


    CREATE OR REPLACE FUNCTION twawi.epreisstaffel__anfangebot__matching(
        IN _est_mengevon numeric,
        IN _est_mengebis numeric,
        IN _aang_id      integer,
        IN _round_to_los boolean,
        IN _ak_los       numeric,
        IN _uf_menge     numeric
        )
        RETURNS boolean AS $$
        DECLARE
          _menge            numeric;
          _est_mengevon_max numeric;
        BEGIN
          -- prüft ob eine bestimmte Menge von einem Staffelpreis erfasst wird

          IF _est_mengevon IS null AND _est_mengebis IS null THEN
              RETURN true;
          END IF;

          _menge := ifThen(
              _round_to_los,
              twawi.Round_ToLos( coalesce( _ak_los, 1 ), _uf_menge ),
              _uf_menge
           );

          -- stellt sicher, dass eine Menge von verschiedenen Preisstaffeln erfasst wird,
          -- sofern die Staffelpreise sinnvoll gepflegt sind
          _est_mengevon_max := max( est_mengevon ) FROM epreisstaffel
              WHERE est_aang_id = _aang_id AND est_mengevon <= _menge;

          RETURN
                _est_mengevon_max = _est_mengevon
            AND (
                   _est_mengebis >= _menge
                OR _est_mengebis IS null
            );
        END $$ LANGUAGE plpgsql STABLE;


    -- Sucht in den Lieferantenpreisen nach dem Preis eines Artikels. Wahlweise wird nur der beste Preis zurückgegeben. Berücksichtigt Angebotsstaffeln, wenn vorhanden
    CREATE OR REPLACE FUNCTION TWawi.Search_LiefAngebot_Preise (
        IN  _aknr           varchar(50),                                -- Artikelnummer. Ausnahme: Bei Auswärtsbearbeitung ist dass das Arbeitspaket.
        IN  _mengeUF1       numeric(12,4),                              -- Gewünschte Menge ...
        IN  _fertaknr       varchar(50)   DEFAULT null,                 -- Fertigungsartikel, wenn bei _aknr ein Arbeitspaket angegeben wurde.
        IN  _liefkrz        varchar(21)   DEFAULT '%',                  -- Lieferanteneinschränkung, im Standard alle.
        IN  _RoundToLos     boolean       DEFAULT true,                 -- Losrundung aktivieren
        IN  _LimitRows      integer       DEFAULT 5,                    -- Maximal soviele Datensätze / Preise zurückgeben ... sortiert nach Alter aufsteigend
        IN  _LimitAge       integer       DEFAULT 365  * TSystem.Settings__GetInteger('EKPMaxAlter'),        -- Maximales Alter des Preises in Tagen
        IN  _PreisZeitpunkt date          DEFAULT current_date,         --  Lieferantenangebote Preisgültigkeit
        OUT preis           TWAWI.Preis
        )
        RETURNS SETOF TWawi.Preis
        AS $$
        DECLARE _p              TWawi.Preis;
                _rec            record;
        BEGIN

          -- notwendig, da mindestens LimitRows aus Oberfläche mit null übergeben wird
          _LimitRows := coalesce( _LimitRows,5 );
          _LimitAge  := coalesce( _LimitAge, 365  * TSystem.Settings__GetInteger('EKPMaxAlter') );
          _PreisZeitpunkt := coalesce(_PreisZeitpunkt, current_date);

          -- Alles anzeigen wenn keine Menge übergeben!
          IF _mengeUF1 IS null THEN
            _PreisZeitpunkt := null;
            _LimitRows := 30;
          END IF;

          FOR _rec IN
              SELECT *
              FROM (
                  SELECT
                      -- ANALOG Order By Klausel halten. Do1If0(aArt_menge) notwendig um Division by zero zu verhindern
                      row_number() OVER (
                         ORDER BY
                           anfrage.insert_date DESC,
                           aang_id DESC,
                           AngPreis / Do1If0( aArt_menge )
                      ) AS rows,
                      anfangebot.dbrid AS anfDBRID,

                      -- Ergänzung zum Staffelpreis #12813 #13308
                      est.est_aang_id,
                      est.dbrid AS estDBRID

                  FROM anfAngebot
                    JOIN anfArt  ON aAng_aArt_id = aArt_id
                    JOIN anfLief ON aLief_id = aAng_aLief_id
                    JOIN anfrage ON aart_anf_nr = anf_nr
                    CROSS JOIN LATERAL getAngebotArtPreis( aang_id, true ) AS AngPreis
                    -- Auswärtsbearbeitung FÜR
                    LEFT JOIN op2 ON aart_op_ix = o2_ix AND aart_o2_n = o2_n
                    -- zusätzlich mit Preisstaffeln
                    LEFT JOIN epreisstaffel est on est_aang_id = aang_id
                    LEFT JOIN artmgc on aart_m_id = m_id
                    LEFT JOIN art on  aart_ak_nr = ak_nr
                  WHERE
                        aart_ak_nr = _aknr
                        -- Lieferant kann eingeschränkt oder beliebig sein
                    AND (   (_fertaknr IS null AND aart_o2_n IS null) -- wenn keine FertigungsArtikelNummer, dann darf auch keine Anfrage für Auswärts
                         OR (_fertaknr = o2_aknr) -- wenn Auswärtsarbeitspaket, muss auch Anfrage für Auswärtsarbeitspaket sein!
                         )
                    AND aLief_lkn LIKE _LiefKrz
                    AND aang_datum > ( current_date - _LimitAge )
                    AND coalesce( aang_preis, 0 ) > 0
                    -- für die Staffelpreise #12813 #13308
                    -- #16227 Verhinderung von Mehrfachtreffern bei fehlenden Obergrenzen
                    AND (   _mengeuf1 IS null
                         OR twawi.epreisstaffel__anfangebot__matching(
                                est_mengevon,
                                est_mengebis,
                                aang_id,
                                _roundtolos,
                                ak_los,
                                _mengeuf1 * m_uf
                            )
                        )
                    AND (   _PreisZeitpunkt IS null
                         OR _PreisZeitpunkt BETWEEN coalesce(aang_gdatum, anfAngebot.insert_date) AND coalesce(aang_bisdatum, 'infinity')
                        )
                  ORDER BY
                    anfrage.insert_date DESC,
                    aang_id DESC,
                    -- Angebote auf neueste Anfragen, dann Betrag ...dann Betrag ...
                    AngPreis / Do1If0( aArt_menge )

              ) as sq1  --  Mengen ? Normprüfung erforderlich ? -> TAdk.Check_EKNorm(aknr,''::VARCHAR),TRUE)
              WHERE rows <= _LimitRows
          LOOP

              -- Angebotsstaffeln #12813 #13308
              IF _rec.est_aang_id IS NULL THEN
                  -- kein Staffelpreis
                  -- MengeUF1 reingeben, das wird beim Erstellen nochmal umgerechnet und gerundet
                  _p := TWawi.Create_Preis( 'anfAngebot'       , _rec.anfDBRID, _mengeuf1, _RoundToLos );
              ELSE
                  -- Staffelpreis
                  _p := TWawi.Create_Preis( 'anfAngebotStaffel', _rec.estDBRID, _mengeUF1, _RoundToLos );
              END IF;

              IF _p.IsValid THEN
                  preis := _p;
                  RETURN NEXT;
              END IF;

          END LOOP;

          RETURN;

        END $$ LANGUAGE plpgsql STABLE;
        --

    -- Baut einen Preis aus den Selbkosten im Artikelstamm. Kapselt Create_Preis weg, damit das nach außen als 'Search_' angeboten wird
    CREATE OR REPLACE FUNCTION TWawi.Search_Selbstkosten( IN _aknr varchar(50), IN _mengeGME numeric(12,4), _RoundToLos boolean DEFAULT TRUE )  RETURNS TWawi.Preis AS $$
    DECLARE _p TWawi.Preis;
    BEGIN
      _p := TWawi.Create_Preis('art', dbrid, _mengeGME, _RoundToLos) FROM art WHERE ak_nr = _aknr;
      -- Kein Selbstkosteneintrag -> ungültig.
      IF coalesce(_p.Preis,0) = 0 THEN
        _p.IsValid := false;
      END IF;
      RETURN _p;
    END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT; --Nur ausführen wenn alle Parameter <> NULL
    --

    -- Bereitstellung jüngster Bestellpreis für #13281
    CREATE OR REPLACE FUNCTION TWawi.Search__ldsdok__allePreise(
        IN _aknr           varchar(50),
        IN _mengeUF1       numeric(12,4),
        IN _liefkrz        varchar(21) DEFAULT '%',
        IN _RoundToLos     boolean DEFAULT true,
        IN _bestPreisOnly  boolean DEFAULT false,
        OUT preis          TWAWI.Preis)
        RETURNS SETOF TWawi.Preis
        AS $$
        DECLARE
          _p                    TWawi.Preis;
          _rec                  record;
          _EKRahmenNachAblauf   boolean;     -- Ende Termin des Rahmens ignorieren und trotzdem vorschlagen, wenn noch Menge offen ist.
          _AuslaufAknr          varchar(40); -- Ablaufender Artikel
        BEGIN

          _EKRahmenNachAblauf  := coalesce( TSystem.Settings__GetBool('EKRahmenNachAblauf' ), false);

          _AuslaufAknr := '';

          FOR _rec IN
            SELECT ldsdok.dbrid, ld_aknr
              FROM ldsdok
             WHERE (NOT ld_done)                                                -- Nicht abgeschlossener
               AND (ld_stkl < ld_stk_uf1)                                       -- ... mit offener Restmenge
               AND ((ld_aknr = _aknr) OR ( ld_aknr = coalesce(_AuslaufAknr,'')))  -- ... für den Artikel oder den, den dieser Artikel ersetzt
               AND (_liefkrz  IS null OR ( ld_kn LIKE _liefkrz))                  -- ... bei dem gewünschten (oder irgendeinem) Lieferant
               AND  ((coalesce(ld_terml , termweek_to_date(ld_termweekl, false), current_date) >= current_date) OR (_EKRahmenNachAblauf and ld_code = 'R')) -- ... Wenn Ende-Datum vorhanden, dann darf das noch nicht erreicht sein
             ORDER BY coalesce(ld_term  , termweek_to_date(ld_termweek, true )) DESC, ld_datum DESC   -- jüngste zuerst

          LOOP --Über alle gefundenen Bestellungen laufen und einen Preis  zusammenbauen

            -- Erstellt aus dem Ldsdok-Datensatz ein Preisobjekt. Macht Losrundung, Abrufreduzierung auf Restmenge, Abzu einrechnen
            _p:=TWawi.Create_Preis('ldsdok', _rec.dbrid, _mengeUF1, _RoundToLos);

            -- Das ist ein anderer Artikel? Muss ein Auslaufartikel sein und der gesuchte Artikel ist Ersatzartikel.
            IF (_rec.ld_aknr <> _aknr) THEN

              _p.source_bez := '!A! ' || lang_text(6129) || ' ' || _rec.ld_aknr || ', ' || _p.source_bez; --  !A! Auslaufartikel ARTXYZ, Rahmen: R2014-XYZ/1 ...

              -- Wir wollen nicht den Auslaufartikel im Preis haben, sondern den gesuchten. Der Auslaufartikel steht ja schon im source_bez Text mit.
              _p.ak_nr     := _aknr;
              -- Als Abrufmengeneinheit benötigen wir die gleiche ME, aber mit artmgcid des neuen Artikels
              -- Mit FALSE gibt es keinen Fallback auf die Standard-ME, das bleibt also leer, wenn die ME des Rahmens im
              -- neuen Artikel nicht definiert ist.
              _p.artmgcid  := TArtikel.me__convertme_for_art__by__mid(_aknr, _p.artmgcid, false);
            END IF;

            preis := null;
            IF _p.IsValid THEN
               preis := _p;
               RETURN NEXT;
            END IF;

            IF _bestPreisOnly THEN
               EXIT;
            END IF;

          END LOOP;

        END $$ LANGUAGE plpgsql STABLE;



    -- Aktualisiert eine Bestellanforderungsposition mit den Daten aus dem übergebenen Preis
    CREATE OR REPLACE FUNCTION TWawi.Assign_PreisToBestAnfPos(IN _bapid INTEGER, IN _preis TWawi.Preis ) RETURNS boolean AS $$
         DECLARE _bapdbrid varchar;
                 _p        ALIAS FOR _preis;
         BEGIN

             _bapdbrid := dbrid FROM bestanfpos WHERE bap_id = _bapid;

             IF _preis IS NULL THEN
               DELETE FROM preise WHERE target_table = 'bestanfpos' AND target_dbrid=_bapdbrid;
             ELSE
               UPDATE preise SET preis = _p WHERE target_dbrid = _bapdbrid;
               IF NOT FOUND THEN
                 INSERT INTO preise (target_table, target_dbrid, preis) VALUES ('bestanfpos', _bapdbrid, _p);
               END IF;
             END IF;

             IF (_preis IS NULL) OR (_bapid IS NULL) THEN
               RETURN FALSE;
             END IF;

             UPDATE bestanfpos SET bap_lkn = _preis.ad_krz,                                 -- Vorgeschlagener Lieferant für Anfrage/Bestellung
                                   bap_ep_uf1_basisw = _preis.preis_uf1_basisw,             -- Preis in GME und Eigenwährung, das ist ohne Preiseinheit, also ggf. sehr kleiner Betrag (0.0499 für ne Schraube oder so)
                                   bap_rab           = _preis.rabatt                        -- Rabatt (laut Lieferantendaten oder manuell eingegeben)
                   WHERE bap_id = _bapid AND ( bap_lkn           IS DISTINCT FROM _preis.ad_krz
                                           OR bap_ep_uf1_basisw  IS DISTINCT FROM _preis.preis_uf1_basisw
                                           OR bap_rab            IS DISTINCT FROM _preis.rabatt);

             RETURN FOUND;
         END $$ LANGUAGE plpgsql VOLATILE;

        --

    -- Funktion aktualisiert die Preise am Lieferanten und
    -- Gibt e_id des Lieferanten-Datensatzes zurück
    CREATE OR REPLACE FUNCTION TWawi.EPreis_Update(
          IN  p        TWawi.Preis,

              -- Zuschläge kopieren
          IN  copyabzu boolean = true,

              -- Normalerweise aktualisieren wenn Lieferant vorhanden, wenn nicht neu anlegen.
              -- ForceInsert legt immer neu an.
          IN  forceinsert boolean = false
          )
          RETURNS integer AS $$

          DECLARE
              -- ID des Lieferantendatensatzes den wir updaten
              eid   integer;
              -- Preisdaten-Record, Zusatzkram der nicht im Composite-Type steht.
              pdr   record;
          BEGIN

              -- Lieferantendatensatz anlegen oder aktualisieren mit dem übergebenen Preis-Objekt.

              -- 'Lieferantendaten aktualisieren' ...
              --   => Stammlieferant bleibt erhalten
              --   => Gültig ab = Preisdatum, Gültig bis = NULL
              --   => Zuschläge updaten, alle Alten rauslöschen und dann neu kopieren
              --   => Menge: Angebot beibehalten, Eingangsrechnung beibehalten
              --   => Wenn Staffeln, dann Fehler -> Manuell anpassen

              -- TWawi.EPreis_Create: Lieferantendaten aus TWawi.Preis anlegen ist nicht implementiert für Tabelle %
              IF p.source_table NOT IN ( 'belegpos', 'anfangebot', 'anfangebotstaffel' ) THEN
                  RAISE EXCEPTION 'TWawi.EPreis_Create: %', format( lang_text( 29152 ), p.source_table );
              END IF;

              -- Sammeln der Zusatzinformationen aus Angebot oder Eingangsrechnung
              SELECT pi.*,
                     coalesce( aang_id, belp_id, est_aang_id ) AS AbzuParentID,
                     aang_lieferzeit                           AS eLfzt,
                     aang_akref                                AS eBest,
                     coalesce( aang_txtint, belp_txt )         AS eTxt,
                     coalesce( aang_txtint_rtf, belp_txt_rtf ) AS eTxt_Rtf,
                     est_aang_id, aang_bisdatum
                INTO pdr
                FROM TWawi.GetPreisInfo( p.Source_table, p.Source_dbrid ) AS pi
                LEFT JOIN anfAngebot    ON  anfangebot.dbrid    = p.Source_dbrid
                LEFT JOIN epreisstaffel ON  est_aang_id = aAng_id -- zugehörige Staffeln
                LEFT JOIN eingrech_pos  ON  eingrech_pos.dbrid  = p.Source_dbrid
              ;

              -- Den neuesten nicht abgelaufenen Preis des Artikels beim Lieferant suchen.
              -- (Hinweis: An der Stelle wäre zu überlegen ob man epreis.e_sourcetable und e_sourcedbrid einführt)
              eid :=      e_id
                     FROM epreis
                    WHERE
                          e_aknr = p.ak_nr
                      AND e_lkn  = p.ad_krz
                      -- AND COALESCE(e_herkunft,'') NOT LIKE 'ER%' (Wieso nicht aus ERG?, LG)
                      AND coalesce( e_fertaknr, '' ) = coalesce( pdr.fertaknr, '' )
                    ORDER BY
                          e_bisdatum NULLS FIRST,
                          e_gdatum DESC,
                          e_id DESC
                    LIMIT 1;

              -- INSERT - Wir müssen den neu anlegen oder haben noch keinen Satz zum Updaten.
              IF forceinsert OR ( coalesce( eid, 0 ) = 0 ) THEN

                  -- So einfach wie möglich anlegen. Wir Updaten den Datensatz dann weiter unten,
                  -- damit müssen wir die meisten Felder nur einmal hinschreiben.
                  INSERT INTO epreis ( e_aknr, e_fertaknr, e_lkn, e_mcv )
                  VALUES ( p.ak_nr, pdr.fertaknr, p.ad_krz, p.artmgcid ) -- ACHTUNG: unten das Update erfolgt immer, dort weitere Felder
                  RETURNING e_id INTO eid;

                  -- 'Neuer Lieferantendatensatz angelegt'
                  PERFORM prodat_hint( lang_text( 13846 ) );

              ELSE

                  -- UPDATE, prüfen ob Staffelpreis. Die sind derzeit nicht unterstützt.
                  IF EXISTS( SELECT true FROM epreisstaffel WHERE est_e_id = eid ) THEN

                      -- [xtt29154] TWawi.EPreis_Update: Lieferantendatensatz enthält Staffelpreise.
                      --  Muss manuell im Artikelstamm angepasst werden.
                      PERFORM prodat_text( format( lang_text(29154) ) );

                      RETURN eid;
                  END IF;

                  -- ' Lieferantendatensatz wurde aktualisiert.'
                  PERFORM prodat_hint( lang_text( 13847 ) );

              END IF;

              IF coalesce( eid, 0 ) = 0 THEN

                -- [xtt?] TWawi.EPreis_Update: Kein gültiger Lieferantendatensatz gefunden.
                RAISE EXCEPTION 'TWawi.EPreis_Update: %', Format( lang_text( 29153 ) );
              END IF;

              UPDATE epreis SET
                  e_lkn             = p.ad_krz,
                  e_aknr            = p.ak_nr,
                  e_fertaknr        = pdr.fertaknr,
                  e_herkunft        = p.source_bez,
                  e_preis           = p.preis,
                  e_preiseinheit    = p.Preiseinheit,
                  e_waer            = p.wacode,
                  e_rab             = p.rabatt,
                  e_stk             = IfThen( coalesce( p.los, 1 ) <> 1, p.los, p.menge),
                  e_mcv             = p.artmgcid,
                  e_kurs            = p.kurs,
                  e_gdatum          = p.datum,
                  e_bisdatum        = pdr.aang_bisdatum, -- https://redmine.prodat-sql.de/issues/18514
                  e_lfzt            = coalesce( pdr.eLfzt, 1 ),
                  -- Ticket 13535 Lieferantenreferenz (epreis.e_best) darf nicht mit leer überschrieben werden
                  -- Ticket 13535 Lieferantenreferenz (epreis.e_best) darf nur überschrieben werden, falls dort nichts drinsteht
                  e_best            = coalesce( e_best, pdr.eBest ),
                  e_txt             = pdr.eTxt,
                  e_txt_rtf         = pdr.eTxt_rtf
                  -- Verbleibende Felder:
                  -- e_stal,  e_ep, e_rahmen_stk, e_bewer, e_ep_uf1,
                  -- e_ep_uf1_basis_w, e_ep_uf1_basis_w_abzu,
                  -- e_ep_uf1_basis_w_abzu_selbstko, e_ep_abzu
              WHERE e_id = eid;

              -- Zuschläge in Lieferantendaten übernehmen
              IF ( copyabzu AND eid IS NOT NULL ) THEN

                  -- Vorhandene Zuschläge werden gelöscht ...
                  DELETE FROM epreisabzu WHERE eaz_e_id = eid;

                  IF p.Source_table IN ( 'anfangebot', 'anfangebotstaffel' ) THEN
                      PERFORM TWawi.Abzu_Copy( 'anfangebot_abzu', pdr.AbzuParentID::varchar, 'epreis_abzu', eid::varchar, p.menge );
                  ELSIF p.Source_table = 'belegpos' THEN
                      PERFORM TWawi.Abzu_Copy( 'belegpos_abzu', pdr.AbzuParentID::varchar, 'epreis_abzu', eid::varchar, p.menge );
                  END IF;

              END IF;

              IF
                    p.source_table = 'anfangebot'
                AND eid IS NOT NULL
              THEN
                  UPDATE anfangebot SET aang_IsInEpreis = true WHERE anfangebot.dbrid = p.source_dbrid;
              END IF;

              -- Staffelpreise von Lieferantendaten übernehmen, sofern vorhanden
              INSERT INTO epreisstaffel
                       ( est_e_id, est_mengevon, est_mengebis, est_rahmen_stk, est_ep)
                SELECT
                       eid, est_mengevon, est_mengebis, est_rahmen_stk, est_ep
                  FROM epreisstaffel
                 WHERE est_aang_id = pdr.est_aang_id;

              RETURN eid;

          END $$ LANGUAGE plpgsql;

        --


        -----------------------

        --[Obsolet/Kaputt/Entfernen?] Rundet Menge auf Losgröße und gibt das gleiche Preisobjekt zurück
        CREATE OR REPLACE FUNCTION TWawi.Round_ToLos(IN Los NUMERIC(12,2), INOUT preis TWaWI.Preis) AS $$
         DECLARE result NUMERIC;
         BEGIN
          los:=COALESCE(los,0);
          --Keine Losgroesse hinterlegt oder schon passend
          IF (los = 0) THEN
            preis.los:=0;
            preis.menge_los:=preis.menge;
            RETURN;
          END IF;

          preis.los:=los;
          preis.Menge_los:= los * ( div(preis.menge, los) + sign(preis.menge % los) ); -- sign "Rest negativ"  => -1, "Rest = 0"        => 0, "Rest positiv"  => 1
          RETURN;
         END $$ LANGUAGE plpgsql IMMUTABLE;-- RETURNS NULL ON NULL INPUT; --Nur ausführen wenn alle Parameter <> NULL
        --

        --
        CREATE OR REPLACE FUNCTION TWawi.Round_ToLos(
              los           NUMERIC,
              menge         NUMERIC,
              limit_menge   BOOLEAN = false
          ) RETURNS NUMERIC AS $$
          BEGIN
              -- Rundet Menge auf Losgröße und gibt gerundeten Wert zurück

              -- Keine Losgroesse hinterlegt oder schon passend
              los := COALESCE(los, 0);

              IF los = 0 THEN
                  RETURN menge;
              END IF;

              RETURN los * TArtikel.LosFaktor(menge, los, limit_menge);
          END $$ LANGUAGE plpgsql IMMUTABLE;
        --

        --Ändert die Mengeneinheit und rechnet alle relevanten Preise und Mengen in die neue ME um. Ist die Ziel-ME NULL, passiert einfach nichts.
         -- DROP FUNCTION IF EXISTS TWawi.Change_ME(INTEGER, TWawi.Preis);
        CREATE OR REPLACE FUNCTION TWawi.Change_ME(IN newArtMgcID INTEGER, INOUT preis TWaWI.Preis) AS $$
          DECLARE ouf    NUMERIC; --Umrechnungsfaktor alte ME zur GME
                 nuf    NUMERIC; --Umrechnungsfaktor neue ME zur GME
                 p      ALIAS FOR preis;
         BEGIN

          -- Wenn die Funktion leer aufgerufen wird, machen wir gar nichts am Preis und gehen raus. Spart Zeit.
          IF (p.artmgcid IS NULL) OR (p.artmgcid = newArtMgcID) OR (newArtMgcID IS NULL) THEN
              RETURN;
          END IF;

          ouf:=m_uf FROM artmgc WHERE m_id = p.artmgcid;
          nuf:=m_uf FROM artmgc WHERE m_id=newArtMgcID;
          IF (nuf IS NULL) OR (ouf IS NULL) THEN
            RAISE EXCEPTION 'TWawi.Change_ME: %', Format(lang_text(29155) /*'Umrechnungsfaktor für alte oder neue ME nicht gefunden. Alt: %, Neu: %'*/, ouf, nuf);
          END IF;

          p.preis:=p.preis_uf1 / nuf * p.preiseinheit;
          p.menge:=p.Menge / ouf * nuf;
          p.menge_los:=p.menge_los / ouf * nuf;
          p.los:=p.los / ouf * nuf;
          p.artmgcid:=newartmgcid;
          RETURN;
         END $$ LANGUAGE plpgsql STABLE;
        --

        --Ändert die Währung in der der Preis angegeben ist und rechnet alle relevanten Preise und Mengen um. Wird Kurs weggelassen, wird der aktuelle Kurs aus Stammdaten genommen.
        CREATE OR REPLACE FUNCTION TWawi.Change_Waehrung(IN newWaco VARCHAR(3), IN kurs NUMERIC, INOUT preis TWaWI.Preis) AS $$
          DECLARE oKurs  NUMERIC; --Umrechnungsfaktor alte ME zur GME
                  nKurs  NUMERIC; --Umrechnungsfaktor neue ME zur GME
                  p      ALIAS FOR preis;
         BEGIN

          -- Währung und Kurs gleich geblieben oder keine Sinnvollen Parameter? => Fertig und raus.
          if (newWaco IS NULL) OR (preis IS NULL) OR ( (newWaco IS NOT DISTINCT FROM p.WaCode) AND (kurs IS NOT DISTINCT FROM p.Kurs)) THEN
            RETURN;
          END IF;

          oKurs:=p.Kurs;
          nkurs:=COALESCE(kurs,wa_kurs) FROM bewa WHERE wa_einh = newWaco;

          IF (oKurs IS NULL) OR (nkurs IS NULL) THEN
            RAISE EXCEPTION 'TWawi.Change_Waehrung: %', Format(lang_text(29156) /*Umrechnung nicht möglich. Neuer oder alter Kurs nicht gefunden. Alt: %, Neu: %'*/, oKurs, nKurs);
          END IF;

          p.preis       :=p.preis * oKurs / nKurs;
          p.preis_uf1   :=p.preis_uf1 * oKurs / nKurs;
          p.Kurs        :=nKurs;
          p.wacode      :=newWaco;

          RETURN;
         END $$ LANGUAGE plpgsql STABLE;
        --

        --Sucht aus einem Array von Preisen den günstigsten raus
        CREATE OR REPLACE FUNCTION TWawi.Min_Preis(IN preise TWaWI.Preis[]) RETURNS TWaWi.Preis AS $$
          DECLARE ps      ALIAS FOR preise;
                  p       TWawi.Preis;
                  pMin    TWawi.Preis;
                  i      INTEGER;
         BEGIN
            pMin.preis_uf1_basisw_abzu:=999999999;
            FOR i IN array_lower(ps, 1) .. array_upper(ps, 1) LOOP
              p:=ps[i];
              IF p.IsValid AND (p.preis_uf1_basisw_abzu < pMin.preis_uf1_basisw_abzu) THEN
                pMin:=p;
              END IF;
            END LOOP;

            IF pMin.IsValid THEN
              RETURN pMin;
            ELSE
              RETURN NULL;
            END IF;
         END $$ LANGUAGE plpgsql STABLE  RETURNS NULL ON NULL INPUT; --Nur ausführen wenn alle Parameter <> NULL;
        --

        --Sucht aus einem Array von Preisen den höchsten Preis raus
        CREATE OR REPLACE FUNCTION TWawi.Max_Preis(IN preise TWaWI.Preis[]) RETURNS TWaWi.Preis AS $$
          DECLARE ps     ALIAS FOR preise;
                  p      TWawi.Preis;
                  pMax   TWawi.Preis;
                  i      INTEGER;
         BEGIN
            pMax.preis_uf1_basisw_abzu:=-999999999;
            FOR i IN array_lower(ps, 1) .. array_upper(ps, 1) LOOP
              p:=ps[i];
              IF p.IsValid AND (p.preis_uf1_basisw_abzu > pMax.preis_uf1_basisw_abzu) THEN
                pMax:=p;
              END IF;
            END LOOP;

            IF pMax.IsValid THEN
              RETURN pMax;
            ELSE
              RETURN NULL;
            END IF;
         END $$ LANGUAGE plpgsql STABLE  RETURNS NULL ON NULL INPUT; --Nur ausführen wenn alle Parameter <> NULL;
        --

        --[Obsolet?] Fasst wichtigste Informationen aus einem Preis mit Ursprung und Betrag als VARCHAR zusammen. Zur Anzeige in Hints, Grids oder als Debughilfe
        CREATE OR REPLACE FUNCTION TWawi.As_DisplayText(IN preis TWaWI.Preis) RETURNS VARCHAR AS $$
         DECLARE p      ALIAS FOR preis;
                 descr  VARCHAR;
                 src    VARCHAR;
         BEGIN
          IF (p IS NULL) THEN
            RETURN '-';
          END IF;

          IF (COALESCE(p.source_dbrid,'')='') THEN
            RETURN lang_text(970); --unbekannt
          END IF;

          -- Beispiel: 0.25 EUR/STK, Menge 20, S.-Lieferant, "MUSTERMANN"
          descr:= ROUND(COALESCE(p.preis_uf1_basisw_abzu,0),2) || ' ' || p.wacode;
          descr:= descr || '/'  || COALESCE(standardmgc_iso(p.ak_nr),lang_text(29192) /*'?ME?'*/);
          descr:= descr || ', ' || lang_text(555) ||': ' || ROUND(COALESCE(p.menge_los,0),2) || ' ' || lang_artmgc_id_iso(p.artmgcid);
          --descr:= LPad(descr,30,' ');
          descr:= descr || ', '  || COALESCE(p.source_bez,lang_text(29193) /*'?Herkunft?'*/);
          if COALESCE(p.ad_krz,'')<>'' THEN
            descr:= descr || ', ' || COALESCE(p.ad_krz,'');
          END IF;

          RETURN descr;
         END $$ LANGUAGE plpgsql STABLE  RETURNS NULL ON NULL INPUT; --Nur ausführen wenn alle Parameter <> NULL;
        --

        --[Obsolet?] Erweitert die Felder in einem Preis um Artikel/Adressbezeichnungen und andere Felder die für den Nutzer interessant sein könnten.
         DROP FUNCTION IF EXISTS TWawi.As_DefaultF2View(TWawi.Preis);
        CREATE OR REPLACE FUNCTION TWawi.As_DefaultF2View(IN _preis TWaWI.Preis,
              OUT dbrid                     varchar(32),
              OUT IsValid                   boolean,
              OUT ak_ac                     varchar(9),
              OUT ak_nr                     varchar(40),
              OUT ak_bez                    varchar(100),
              OUT ad_krz                    varchar(21),
              OUT ad_bez                    varchar(200),
              OUT datum                     date,
              OUT datum_bis                 date,
              OUT source_bez                varchar(100),
              OUT pos_netto                 numeric(12,2),
              OUT menge_uf1                 numeric(12,4),
              OUT menge_los_uf1             numeric(12,4),
              OUT m_iso_uf1                 varchar(10),
              OUT preis_uf1_basisw          numeric(12,4),
              OUT preis_uf1_basisw_abzu     numeric(12,4),
              OUT basisw                    varchar(3),
              OUT hasAbzu                   boolean,
              OUT rabatt                    numeric(5,2),
              OUT los                       numeric(12,4),
              OUT kurs                      numeric(12,4),
              OUT steuproz                  numeric(5,2),
              OUT menge                     numeric(12,4),
              OUT menge_los                 numeric(12,4),
              OUT m_iso                     varchar(10),
              OUT preis                     numeric(12,4),
              OUT wacode                    varchar(3),
              OUT artmgcid                  integer,
              OUT minPreis                  numeric(12,4),
              OUT maxPreis                  numeric(12,4),
              OUT abzubetrag_uf1_basisw     numeric(12,6),
              OUT LinkKeyField              varchar(40)  ,
              OUT LinkKeyValue              varchar(40)
            )
            RETURNS record
            AS $$
            DECLARE pr ALIAS FOR _preis;
            BEGIN
              SELECT
                  p.source_dbrid, p.IsValid, a.ak_ac, a.ak_nr, a.ak_bez, p.ad_krz, adressebez(p.ad_krz), p.datum, p.datum_bis, p.source_bez,
                  tartikel.me__menge__in__menge_uf1(p.artmgcid,p.menge_los)  * p.preis_uf1_basisw_abzu as pos_netto,
                  tartikel.me__menge__in__menge_uf1(p.artmgcid, p.menge) AS menge_uf1, tartikel.me__menge__in__menge_uf1(p.artmgcid,p.menge_los)  AS menge_los_uf1,
                  lang_artmgc_id_iso(tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(p.ak_nr)) AS m_iso_uf1, p.preis_uf1_basisw, p.preis_uf1_basisw_abzu, TSystem.Settings__Get('BASIS_W'),
                  p.hasAbzu, p.rabatt, p.los, p.kurs, p.steuproz,
                  p.menge, p.menge_los, lang_artmgc_id_iso(p.artmgcid) AS m_iso, p.preis, p.wacode,
                  p.artmgcid,p.minPreis, p.maxPreis, p.abzubetrag_uf1_basisw,
                  CASE WHEN p.Source_table = 'ldsdok'        THEN 'ldsdok_rahmen.ld_auftg'
                       WHEN p.Source_table = 'epreis'        THEN 'art.ak_nr'
                       WHEN p.Source_table = 'epreisstaffel' THEN 'art.ak_nr'
                       WHEN p.Source_table = 'art'           THEN 'art.ak_nr'
                  END AS LinkKeyField,
                  --
                  CASE WHEN p.Source_table = 'ldsdok'        THEN ld_auftg
                       WHEN p.Source_table = 'epreis'        THEN p.ak_nr
                       WHEN p.Source_table = 'epreisstaffel' THEN p.ak_nr
                       WHEN p.Source_table = 'art'           THEN p.ak_nr
                  END AS LinkKeyValue
                  -- ldsdok, epreis, epreisstaffel, art
                  INTO
                  dbrid, IsValid, ak_ac, ak_nr, ak_bez, ad_krz, ad_bez, datum, datum_bis, source_bez, pos_netto, menge_uf1, menge_los_uf1, m_iso_uf1, preis_uf1_basisw,
                  preis_uf1_basisw_abzu, basisw, hasAbzu, rabatt, los, kurs, steuproz, menge, menge_los, m_iso, preis, wacode, artmgcid, minPreis, maxPreis, abzubetrag_uf1_basisw,
                  LinkKeyField, LinkKeyValue
              FROM ( SELECT * FROM (SELECT (pr).*) as inputpreis) as p
                    LEFT JOIN art    AS a ON p.ak_nr = a.ak_nr
                    LEFT JOIN ldsdok      ON p.source_table ='ldsdok' AND p.source_dbrid = ldsdok.dbrid;
              RETURN;
            END $$ LANGUAGE plpgsql STABLE;

        --

        --Erweitert die Felder in einem Preis um Artikel/Adressbezeichnungen und andere Felder die für den Nutzer interessant sein könnten.
         DROP FUNCTION IF EXISTS    TWawi.Format_Preis (TWawi.Preis);
        CREATE OR REPLACE FUNCTION TWawi.Format_Preis (IN _preis TWaWi.Preis,
            -- Artikel- und Adressbasisdaten
              OUT prIsValid                 boolean,
              OUT prAknr                    varchar(40)  ,
              OUT prAkBez                   varchar(100) ,
              OUT prAdKrz                   varchar(21)  ,
              OUT prAdBez                   varchar(200) ,
              OUT prSrcBez                  varchar(100) ,
              OUT prDatum                   date         ,
              OUT prDatum_Bis               date,
            -- Menge, Preisangaben und preisbestimmende Felder
              OUT prMenge                   numeric(12,4),
              OUT prMenge_Los               numeric(12,4),
              OUT prMeIso                   varchar(10)  ,
              OUT prPreis                   numeric(12,4),
              OUT prPreisEinheit            numeric(12,4),
              OUT prPreis_Abzu              numeric(12,4),
              OUT prAbzu                    numeric(12,4),
              OUT prWe                      varchar(3)   ,
              OUT prRabatt                  numeric(5,2) ,
              OUT prLos                     numeric(12,4),
              OUT prKurs                    numeric(12,4),
              OUT prSProz                   numeric(5,2) ,
              OUT prSCode                   integer      ,
            -- Gesamtpreis und Alternativen
              OUT prPosNetto                numeric(12,2),
              OUT prMinPreis                numeric(12,4),
              OUT prMaxPreis                numeric(12,4),
            -- Quelle und Verlinkungen
              OUT prSrcTable                varchar(40)  ,
              OUT prSrcDBRID                varchar(32)  ,
              OUT prLinkKeyField            varchar(40)  ,
              OUT prLinkKeyValue            varchar(40)
            )
            RETURNS record
            AS $$
            DECLARE pr ALIAS FOR _preis;
            BEGIN
             SELECT p.IsValid, p.ak_nr, a.ak_bez, p.ad_krz, adressename(p.ad_krz), p.Source_bez, p.Datum, p.datum_bis,
                    p.menge, p.menge_los, lang_artmgc_id_iso(p.artmgcid), p.preis, p.preiseinheit, p.preis_uf1_basisw_abzu, p.abzubetrag_uf1_basisw,
                    p.wacode, p.rabatt, p.los, p.kurs, p.Steuproz, p.Steucode,
                    tartikel.me__menge__in__menge_uf1(p.artmgcid,p.menge_los)  * p.preis_uf1_basisw_abzu,
                    p.minPreis, p.maxPreis, p.source_table, p.source_dbrid,
                 CASE WHEN p.Source_table = 'ldsdok'        THEN 'ldsdok_rahmen.ld_auftg'
                      WHEN p.Source_table = 'epreis'        THEN 'art.ak_nr'
                      WHEN p.Source_table = 'epreisstaffel' THEN 'art.ak_nr'
                      WHEN p.Source_table = 'art'           THEN 'art.ak_nr'
                 END AS LinkKeyField,
                 --
                 CASE WHEN p.Source_table = 'ldsdok'        THEN ld_auftg
                      WHEN p.Source_table = 'epreis'        THEN p.ak_nr
                      WHEN p.Source_table = 'epreisstaffel' THEN p.ak_nr
                      WHEN p.Source_table = 'art'           THEN p.ak_nr
                 END AS LinkKeyValue
                 -- ldsdok, epreis, epreisstaffel, art
                 INTO prIsValid, prAknr, prAkBez, prAdkrz, prAdBez, prSrcBez, prDatum, prDatum_Bis,
                      prMenge, prMenge_los, prMeIso, prPreis, prPreiseinheit, prPreis_abzu, prAbzu, prWe, prRabatt, prLos, prKurs, prSProz, prSCode,
                      prPosNetto, prMinPreis, prMaxPreis, prSrcTable, prSrcDBRID, prLinkKeyField, prLinkKeyValue
             FROM ( SELECT * FROM (SELECT (pr).*) as inputpreis) as p
             LEFT JOIN art    AS a ON p.ak_nr        = a.ak_nr
             LEFT JOIN ldsdok      ON p.source_table = 'ldsdok' AND p.source_dbrid = ldsdok.dbrid
             CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get( p.steucode )
             ;
             RETURN;
            END $$ LANGUAGE plpgsql STABLE;

        --

        -- Liefertermin berechnen je nach Quelle ohne WE und Feiertage
        CREATE OR REPLACE FUNCTION TWawi.GetLieferTermin(IN scr_table VARCHAR, IN src_dbrid VARCHAR, IN start_date DATE) RETURNS DATE AS $$
          DECLARE adddays INTEGER;
          BEGIN
            IF    scr_table = 'ldsdok' THEN
                adddays:= ak_bfr FROM ldsdok JOIN art ON ak_nr = ld_aknr WHERE ldsdok.dbrid = src_dbrid;
            ELSIF scr_table = 'art' THEN
                adddays:= ak_bfr FROM art WHERE dbrid = src_dbrid;
            ELSIF scr_table = 'epreis' THEN
                adddays:= e_lfzt FROM epreis WHERE dbrid = src_dbrid;
            ELSIF scr_table = 'epreisstaffel' THEN
                adddays:= e_lfzt FROM epreisstaffel JOIN epreis ON e_id = est_e_id WHERE epreisstaffel.dbrid = src_dbrid;
            END IF;

            adddays:= COALESCE(adddays, 0);
            RETURN timediff_adddays(start_date, adddays, true, true);
         END $$ LANGUAGE plpgsql STABLE STRICT;
        --


        CREATE OR REPLACE FUNCTION z_50_customer.e_folgeap_op_ix__custom_code(
            IN _e_folgeap_op_ix__disabled boolean,
            IN _e_folgeap_op_ix           integer
            )
            RETURNS integer
            AS $$
            BEGIN
                -- Absicherung Kundenspzifischer Code.
                -- CNC > z_50_customer.e_folgeap_op_ix__custom_code in z01-customer.sql
                IF TSystem.Settings__GetBool('e_folgeap_op_ix__custom_code') THEN
                    RAISE EXCEPTION '"FUNCTION z_50_customer.e_folgeap_op_ix__custom_code": custom code exists but function was overridden by standard';
                END IF;
                RETURN -1;
            END $$ LANGUAGE plpgsql;

        CREATE OR REPLACE FUNCTION twawi.e_folgeap_op_ix__calculate_code(
            IN _e_folgeap_op_ix__disabled boolean,
            IN _e_folgeap_op_ix           integer
            )
            RETURNS integer
            AS $$
            DECLARE result integer;
            BEGIN
                result := z_50_customer.e_folgeap_op_ix__custom_code(_e_folgeap_op_ix__disabled, _e_folgeap_op_ix);

                -- wenn es keinen custom code code => -1 = default value
                IF result  = -1 THEN
                   result := ifthen(_e_folgeap_op_ix__disabled, null, _e_folgeap_op_ix);
                END IF;

                RETURN result;
            END $$ LANGUAGE plpgsql;


        -- Für Rahmenverträge und Lieferantendaten die Rahmenmengen und Zusatztexte zurückgeben. Das könnte evtl. bei nächster Erweiterung von TWawi.Preis mit als Comp.Type Spalten da rein, solange bleibt das halt hier.
          -- DROP FUNCTION IF EXISTS TWawi.GetPreisInfo(VARCHAR,VARCHAR);
        CREATE OR REPLACE FUNCTION TWawi.GetPreisInfo(
          IN  scr_table     varchar,
          IN  src_dbrid     varchar,
          OUT rahmen_menge  numeric(14,6),
          OUT preis_txt     text,
          OUT FertAknr      varchar,
          OUT FertAkBez     varchar,
          OUT folgeap_op_ix integer
          )
          RETURNS record
          AS $$
          DECLARE
              r record;
              srcdbrid varchar;
          BEGIN

            -- Für Rahmenverträge und Lieferantendaten die Rahmenmengen und Zusatztexte zurückgeben. Könnte evtl. bei nächster Erweiterung von TWawi.Preis mit als Comp.Type Spalten da rein.
            IF    scr_table = 'ldsdok' THEN
                SELECT ld_stk, ld_txtint, NULL, NULL, ld_folgeap_op_ix
                  INTO rahmen_menge, preis_txt, fertaknr, fertakbez, folgeap_op_ix FROM ldsdok WHERE ldsdok.dbrid = src_dbrid;
            ELSIF scr_table = 'epreis' THEN
                SELECT e_rahmen_stk, e_txt, e_fertaknr, lang_artbez(e_fertaknr, currlang()), twawi.e_folgeap_op_ix__calculate_code(e_folgeap_op_ix__disabled, e_folgeap_op_ix)
                  INTO rahmen_menge, preis_txt, fertaknr, fertakbez, folgeap_op_ix  FROM epreis WHERE epreis.dbrid = Src_dbrid;
            ELSIF scr_table = 'epreisstaffel' THEN
                SELECT est_rahmen_stk, e_txt, e_fertaknr, lang_artbez(e_fertaknr, currlang()), twawi.e_folgeap_op_ix__calculate_code(e_folgeap_op_ix__disabled, e_folgeap_op_ix)
                  INTO rahmen_menge, preis_txt, fertaknr, fertakbez, folgeap_op_ix  FROM epreisstaffel JOIN epreis ON e_id = est_e_id WHERE epreisstaffel.dbrid = src_dbrid;

            ELSIF scr_table = 'belegpos' THEN -- TODO Klärung TSystem_wawi - Benennung? https://redmine.prodat-sql.de/issues/14039
                -- Über Eing.Rechnungspositions und a2_id den Fertigungsartikel ermitteln
                SELECT belp_txt, belp_a2_id INTO r FROM eingrech_pos WHERE eingrech_pos.dbrid = src_dbrid;
                FertAknr := ld_aknr FROM ab2 JOIN abk ON ab_ix = a2_ab_ix JOIN ldsdok ON ab_ld_id = ld_id WHERE r.belp_a2_id IS NOT NULL AND a2_id =r.belp_a2_id;
                SELECT NULL, r.belp_txt, fertAknr, lang_artbez(fertAknr, currlang())
                    INTO rahmen_menge, preis_txt, fertaknr, fertakbez;

            ELSIF scr_table IN ( 'anfangebot', 'anfangebotstaffel' ) THEN

                -- Wenn Quelle die Preisstaffel des Angebots,
                --   dann muss die dbrid aus diesem Angebot ermittelt werden
                IF scr_table = 'anfangebot' THEN
                    srcdbrid := src_dbrid;
                ELSE
                    srcdbrid :=
                      anfangebot.dbrid
                      FROM anfangebot
                      JOIN epreisstaffel ON
                              aang_id = est_aang_id
                          AND epreisstaffel.dbrid = src_dbrid;
                END IF;

                -- Über Abk- oder ASk-Index  den Fertigungsartikel ermitteln
                SELECT aang_txtint, COALESCE(ld_aknr, op_n) AS fertaknr INTO r
                  FROM anfangebot JOIN  anfart ON aang_aart_id = aart_id
                        LEFT JOIN opl    ON aart_op_ix = op_ix
                        LEFT JOIN abk    ON aart_ab_ix = ab_ix
                        LEFT JOIN ldsdok ON ab_ld_id   = ld_id
                  WHERE anfangebot.dbrid = srcdbrid;
                SELECT NULL, r.aAng_txtint, r.fertAknr, lang_artbez(r.fertAknr, currlang())
                  INTO rahmen_menge, preis_txt, fertaknr, fertakbez;
            END IF;
            RETURN;
         END $$ LANGUAGE plpgsql STABLE STRICT;
        --

        -- #7686 Interessentenverwaltung: Angebot für mehrere Positionen PL-SQL-Lösung
        CREATE OR REPLACE FUNCTION TWaWi.kundanfrage_auftg_create(_ag_astat VARCHAR, _ag_nr VARCHAR, _kanfp_ids VARCHAR) RETURNS INTEGER AS $$
          DECLARE r_ka              RECORD;
                  ids               INTEGER[];
                  _ag_pos           INTEGER;
                  _posSchritt       INTEGER;
                  _ag_aknr_referenz VARCHAR;
                  out_ag_id         INTEGER;
                  _ag_kukl          INTEGER;
                  _ag_preis         NUMERIC;
          BEGIN
            -- Keine Eingabe, dann raus
            IF COALESCE(_ag_astat, '') = '' OR COALESCE(_ag_nr, '') = '' OR COALESCE(trim(_kanfp_ids), '') = '' THEN
                RETURN 0;
            END IF;

            _posSchritt := COALESCE(NullIf(TSystem.Settings__GetInteger('AG_POS_WIDTH'), 0), 10);
            _ag_pos     := COALESCE((SELECT MAX(ag_pos) FROM auftg WHERE ag_astat = _ag_astat AND ag_nr = _ag_nr), 0) + _posSchritt;
            ids         := string_to_array(_kanfp_ids, ',');
            out_ag_id   := 0;

            FOR r_ka IN SELECT kundanfragepos.*,
                               kundanfrage.*,
                               kundanfrage.insert_date AS ErstKontakt,
                               TAdk.get_vorg_radress(kanf_ad_krz) AS ag_krzf,
                               steu_z,
                               steu_proz
                          FROM kundanfragepos
                           JOIN kundanfrage ON kanf_nr = kanfp_kanf_nr
                           --JOIN adk ON ad_krz = kanf_ad_krz
                           LEFT JOIN adk1 ON a1_krz = kanf_ad_krz
                           LEFT JOIN steutxt ON steu_z = COALESCE(a1_wuco, TSystem.Settings__GetInteger('auftgsteucode', 3))
                           WHERE kanfp_id = ANY(ids)
                           ORDER BY kanfp_pos
            LOOP
                IF COALESCE(r_ka.kanfp_angnr, '') = '' AND NOT r_ka.kanfp_kein_ang AND COALESCE(r_ka.kanfp_status, 'Q') <> 'B' THEN
                    --- Kunden-ArtikelNr
                    SELECT az_kunr INTO _ag_aknr_referenz FROM artzuo WHERE az_prokrz = r_ka.kanf_ad_krz AND az_pronr = r_ka.kanfp_ak_nr;
                    --- Kunden-Klasse
                    SELECT COALESCE(ad_vpber, 1) INTO _ag_kukl FROM adk WHERE ad_krz = r_ka.kanf_ad_krz;
                    IF r_ka.kanfp_preis IS NULL THEN
                       SELECT (artikel_vkppreis(r_ka.kanfp_ak_nr, r_ka.kanf_ad_krz, NULL, r_ka.kanfp_menge, TSystem.Settings__Get('BASIS_W'), 1, 1)).vkp INTO _ag_preis;
                    ELSE
                       _ag_preis := r_ka.kanfp_preis;
                    END IF;
                    --
                    INSERT INTO auftg (ag_astat,      ag_nr,            ag_pos,           ag_lkn,           ag_krzl,          ag_krzf,      ag_kanf_nr,   ag_an_nr,
                                       ag_kontakt,    ag_aknr,          ag_stk,           ag_preis,         ag_prkl,          ag_kukl,
                                       ag_txt,        ag_txt_rtf,       ag_steucode,      ag_ustpr,         ag_bdat,          ag_aknr_referenz)
                    SELECT             _ag_astat,     _ag_nr,           _ag_pos,          r_ka.kanf_ad_krz, r_ka.kanf_krzl,   r_ka.ag_krzf, r_ka.kanf_nr, r_ka.kanf_an_nr,
                                       r_ka.kanf_api, r_ka.kanfp_ak_nr, r_ka.kanfp_menge, _ag_preis,        1,                _ag_kukl,
                                       txt,           txtrtf,           r_ka.steu_z,      r_ka.steu_proz,   r_ka.ErstKontakt, _ag_aknr_referenz
                    FROM tartikel.adtx_getArtTxtLang(r_ka.kanfp_ak_nr, 'AA', r_ka.kanf_ad_krz)  -- Artikel & Zusatztexte übernehmen
                    RETURNING ag_id INTO out_ag_id;
                    --
                    UPDATE kundanfragepos SET kanfp_angnr = _ag_nr, kanfp_ag_id = out_ag_id WHERE kanfp_id = r_ka.kanfp_id;
                    _ag_pos := _ag_pos + _posSchritt;
                END IF;
            END LOOP;

            RETURN out_ag_id;
          END $$ LANGUAGE plpgsql VOLATILE;
        --

        -- #8468 Erstellung Serviceanfrage über DB-Func
        CREATE OR REPLACE FUNCTION TWaWi.kundservicepos_auftg_create(_ag_astat VARCHAR, _ag_nr VARCHAR, _kanf_nr VARCHAR, _kanfse_id INTEGER, _ak_nr VARCHAR DEFAULT NULL) RETURNS INTEGER AS $$
          DECLARE r_ka              RECORD;
                  ids               INTEGER[];
                  _ag_pos           INTEGER;
                  _posSchritt       INTEGER;
                  _ag_aknr_referenz VARCHAR;
                  out_ag_id         INTEGER;
                  _ag_kukl          INTEGER;
                  _ag_preis         NUMERIC;
                  ag_qnr            INTEGER;
          BEGIN
            -- Keine Eingabe, dann raus
            IF COALESCE(_ag_astat, '') = '' OR COALESCE(_ag_nr, '') = '' OR COALESCE(trim(_kanf_nr), '') = '' THEN
                RETURN 0;
            END IF;

            _posSchritt := COALESCE(NullIf(TSystem.Settings__GetInteger('AG_POS_WIDTH'), 0), 10);
            _ag_pos     := COALESCE((SELECT MAX(ag_pos) FROM auftg WHERE ag_astat = _ag_astat AND ag_nr = _ag_nr), 0) + _posSchritt;
            out_ag_id   := 0;

            -- Servicevorfall
            SELECT q_nr INTO ag_qnr FROM qab WHERE q_kanfse_id = _kanfse_id;

            IF EXISTS(SELECT true FROM kundanfrage WHERE kanf_nr = _kanf_nr) THEN
                SELECT kundservicepos.*,
                       kundanfrage.*,
                       kundanfrage.insert_date AS ErstKontakt,
                       TAdk.get_vorg_radress(kanf_ad_krz) AS ag_krzf,
                       steu_z,
                       steu_proz
                  INTO r_ka
                  FROM kundservicepos
                  JOIN kundanfrage ON kanf_nr = kanfse_kanf_nr
                  LEFT JOIN adk1 ON a1_krz = kanf_ad_krz
                  LEFT JOIN steutxt ON steu_z = COALESCE(a1_wuco, TSystem.Settings__GetInteger('auftgsteucode', 3))
                  WHERE kanfse_id=_kanfse_id; --kanf_nr = _kanf_nr;
                _ak_nr := COALESCE(NullIf(_ak_nr, ''), r_ka.kanf_ak_nr);

                --- Kunden-ArtikelNr
                SELECT az_kunr INTO _ag_aknr_referenz FROM artzuo WHERE az_prokrz = r_ka.kanf_ad_krz AND az_pronr = r_ka.kanf_ak_nr;
                --- Kunden-Klasse
                SELECT COALESCE(ad_vpber, 1) INTO _ag_kukl FROM adk WHERE ad_krz = r_ka.kanf_ad_krz;
                SELECT (artikel_vkppreis(_ak_nr, r_ka.kanf_ad_krz, NULL, /*r_ka.kanf_menge*/1, TSystem.Settings__Get('BASIS_W'), 1, 1)).vkp INTO _ag_preis;
                --
                INSERT INTO auftg (ag_astat,      ag_nr,      ag_pos,      ag_lkn,           ag_krzl,          ag_krzf,      ag_kanf_nr,        ag_an_nr,
                                   ag_kontakt,    ag_aknr,    ag_stk,      ag_preis,         ag_prkl,          ag_kukl,
                                   ag_txt,        ag_txt_rtf, ag_steucode, ag_ustpr,         ag_bdat,          ag_aknr_referenz,  ag_q_nr)
                SELECT             _ag_astat,     _ag_nr,     _ag_pos,     r_ka.kanf_ad_krz, r_ka.kanf_krzl,   r_ka.ag_krzf, r_ka.kanf_nr,      r_ka.kanf_an_nr,
                                   r_ka.kanf_api, _ak_nr,     0,           _ag_preis,        1,                _ag_kukl,
                                   txt,           txtrtf,     r_ka.steu_z, r_ka.steu_proz,   r_ka.ErstKontakt, _ag_aknr_referenz, ag_qnr
                FROM tartikel.adtx_getArtTxtLang(_ak_nr, 'AA', r_ka.kanf_ad_krz)  -- Artikel & Zusatztexte übernehmen
                RETURNING ag_id INTO out_ag_id;

                -- Verknüpfung zum Angebot/Auftrag ~ wird für die gleiche Service-Position ein zweites Angebot erstellt,
                --   dann wird die ID einfach ersetzt; Auftrag geht nur einer über die Oberfläche
                UPDATE kundservicepos SET kanfse_ag_id = out_ag_id WHERE kanfse_id = r_ka.kanfse_id;
                -- Verknüpfung ag_q_nr bei Vorgehen (erst Angebot dann Servicevorfall), siehe qab__a_i_auftg_serviceLink
            ELSE
                out_ag_id = 0;
                --- TODO MsgBox 'Kein Datensatz' ???
            END IF;
            RETURN out_ag_id;
          END $$ LANGUAGE plpgsql VOLATILE;
        --
    --

--Ab- und Zuschläge #####################################################################################################################################
    CREATE OR REPLACE FUNCTION twawi.auftg__abzu__netto__by__ag_id(agid INTEGER, nuroffen BOOL DEFAULT FALSE) RETURNS NUMERIC AS $$
        SELECT COALESCE((SELECT SUM(COALESCE(az_abzubetrag, 0)*az_anz) FROM auftgabzu WHERE az_ag_id=agid AND IFTHEN(nuroffen, az_bebnr IS NULL, true)), 0);
      $$ LANGUAGE sql STABLE;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.auftg_abzu_netto(agid INTEGER, nuroffen BOOL DEFAULT FALSE) RETURNS NUMERIC AS $$
        SELECT twawi.auftg__abzu__netto__by__ag_id(agid, nuroffen);
      $$ LANGUAGE sql STABLE;
    CREATE OR REPLACE FUNCTION twawi.ldsdok__abzu__netto__by__ld_id(ldid INTEGER) RETURNS NUMERIC AS $$
        SELECT COALESCE((SELECT SUM(COALESCE(ldaz_betr, 0)*ldaz_anz) FROM ldsabzu WHERE ldaz_ld_id=ldid), 0);-- AND IFTHEN(nuroffen, az_bebnr IS NULL, true);
      $$ LANGUAGE sql STABLE;


  -- Setzt das Erledigt-Kennzeichen für einen Zuschlag per Tabellenname und Dbrid des Zuschlags (Dyn. SQL)
   -- DROP FUNCTION IF EXISTS TWawi.Abzu_Set_done(VARCHAR,VARCHAR,BOOLEAN,BOOLEAN);
  CREATE OR REPLACE FUNCTION TWawi.Abzu_Set_Done(
      IN  aztable varchar,
      IN  azdbrid varchar,
      IN  DoneFlag boolean,
      IN  einmalkosten_only boolean = TRUE
      )
      RETURNS void
      AS $$
      DECLARE
          viewname varchar;
      BEGIN

        IF (aztable IS NULL) OR (azdbrid IS NULL) THEN RETURN; END IF;

        viewname := LOWER(SubString(TWawi.Abzu_Get_Viewname(aztable), '[^.]*$')); -- Ohne Schema, normalisiert zu 'xyz_abzu' da Schema-Name Probleme im Execute macht.

        EXECUTE 'UPDATE TWawi.' || quote_ident(viewname)
             || '   SET az_done = $1 '
             || ' WHERE ( az_done <> $1) AND dbrid = $2 '
             || IfThen(einmalkosten_only,
                '   AND az_type = ''E''',''
                )
          USING DoneFlag, azdbrid;

        RETURN;
      END $$ LANGUAGE plpgsql VOLATILE;
  --

  -- Ermittel die bisher höchste vergebene Positionsnummer für Zuschläge zu einem bestimmten Parent. Viewname in der Form 'twawi.auftg_abzu' #7829
   -- DROP FUNCTION IF EXISTS TWawi.Abzu_Pos_Max(VARCHAR,VARCHAR);
  CREATE OR REPLACE FUNCTION TWawi.Abzu_Pos_Max(
      IN  _viewname varchar,
      IN  _parent_id varchar
      )
      RETURNS integer
      AS $$
      DECLARE
          pos integer;
      BEGIN
          pos :=       max(az_pos)
                  FROM TWawi.View_All_Abzu
                 WHERE az_parent_id = _parent_id
                   AND az_view = lower(_viewname)
          ;

          RETURN coalesce(pos,0);
      END $$ LANGUAGE plpgsql;
  --


  -- Übersetzt von Abzu-Tabellenname in den Name des TWawiViews zu der Tabelle
   -- DROP FUNCTION IF EXISTS TWawi.Abzu_Get_Viewname(VARCHAR);
  CREATE OR REPLACE FUNCTION TWawi.Abzu_Get_Viewname(aztable varchar)
      RETURNS varchar
      AS $$
           SELECT CASE WHEN trim(lower(aztable)) = 'abzu'            THEN 'twawi.abzu'
                       WHEN trim(lower(aztable)) = 'auftgabzu'       THEN 'twawi.auftg_abzu' --az_done
                       WHEN trim(lower(aztable)) = 'belabzu'         THEN 'twawi.belkopf_abzu'
                       WHEN trim(lower(aztable)) = 'adk1abzu'        THEN 'twawi.adk1_abzu'
                       WHEN trim(lower(aztable)) = 'anfabzu'         THEN 'twawi.anfangebot_abzu'
                       -- TODO KLÄREN BEIDE?!
                       WHEN trim(lower(aztable)) = 'anfangebot_abzu' THEN 'twawi.anfangebot_abzu'
                       WHEN trim(lower(aztable)) = 'ldsabzu'         THEN 'twawi.ldsdok_abzu'  --az_done
                       WHEN trim(lower(aztable)) = 'epreisabzu'      THEN 'twawi.epreis_abzu'
                       WHEN trim(lower(aztable)) = 'belegabzu'       THEN 'twawi.belegdokument_abzu'
                       WHEN trim(lower(aztable)) = 'belegposabzu'    THEN 'twawi.belegpos_abzu'
                       ELSE NULL
                 END AS azViewName;
        $$ LANGUAGE sql STABLE;
  --



  -- Abzuschläge aus Quelle zusammensammeln
  -- Erstellt Datenzeilen
    CREATE OR REPLACE FUNCTION TWawi.Abzu__Create__from__source__by__srcview_parent_id__jsonb(
         IN srcView     varchar,
         IN srcParentID varchar
         )
         RETURNS SETOF  jsonb
         AS $$
         DECLARE rec    record;
         BEGIN

            IF srcView NOT ILIKE 'twawi.%' THEN
               srcView := 'twawi.'||srcView;
            END IF;

            FOR rec IN SELECT *
                         FROM TWawi.View_All_Abzu
                        WHERE az_view = lower(srcView)
                          AND az_parent_id = srcParentID
                          AND NOT coalesce(az_done, false)
                        ORDER BY
                              az_pos
            LOOP
                RETURN NEXT to_jsonb(rec);
            END LOOP;

            RETURN;
         END $$ LANGUAGE plpgsql STRICT;
    -->               FUNCTION TWawi.Abzu__Create__from__source__by__srcview_parent_id  RETURNS SETOF TWawi.View_All_Abzu AS $$
    --
    -- Erstellt Datenzeilen aus srctbl = übersetzung => CALL ... _by__srcview_parent_id__jsonb
    CREATE OR REPLACE FUNCTION TWawi.Abzu__Create__from__source__by__srctbl_dbrid__jsonb (
        IN p_source_table varchar,
        IN p_source_dbrid varchar
        )
        RETURNS SETOF     jsonb
        AS $$
        DECLARE
          srcView         varchar;
          srcParentID     varchar;
        BEGIN

          p_source_table := lower(p_source_table);

          CASE WHEN p_source_table  = 'adk1abzu' THEN
                    srcParentID    :=       a1z_krz
                                       FROM adk1abzu
                                      WHERE dbrid = p_source_dbrid;
               WHEN p_source_table  = 'epreis' THEN
                    srcParentID    :=       e_id
                                       FROM epreis
                                      WHERE dbrid = p_source_dbrid;
               WHEN p_source_table  = 'epreisstaffel' THEN
                    srcParentID    :=       est_e_id
                                       FROM epreisstaffel
                                      WHERE dbrid = p_source_dbrid;
               WHEN p_source_table  = 'anfangebot' THEN
                    srcParentID    :=       aAng_id
                                       FROM anfangebot
                                      WHERE dbrid = p_source_dbrid;
               WHEN p_source_table  = 'anfangebotstaffel' THEN
                    srcParentID    :=       est_aAng_id
                                       FROM epreisstaffel
                                      WHERE dbrid = p_source_dbrid;
               WHEN p_source_table  = 'ldsdok' THEN
                    srcParentID    :=       ld_id
                                       FROM ldsdok
                                      WHERE dbrid = p_source_dbrid;
               -- ergänzt mit #13330
               WHEN p_source_Table  = 'belegpos' THEN
                    srcParentID    :=       belp_id
                                       FROM belegpos
                                      WHERE dbrid = p_source_dbrid;
               ELSE
          END CASE;

          -- ACHTUNG: teilweise wird nicht die dbrid, sondern die parentid übergeben.
          --   zB in epreis_update => PERFORM TWawi.Abzu_Copy( 'anfangebot_abzu', pdr.AbzuParentID::varchar, 'epreis_abzu', eid::varchar, p.menge );
          --   daher - hier entsprechend diese weitergeben, falls die übersetzung dbrid > srcParentID oben nicht geklappt hat. GEMURX!
          srcParentID    := coalesce(srcParentID, p_source_dbrid);

          CASE WHEN p_source_table IN ('epreis', 'epreisstaffel') THEN
                    p_source_table := 'epreisabzu';
               WHEN p_source_table IN ('anfangebot', 'anfangebotstaffel') THEN
                    p_source_table := 'anfangebot_abzu';
               WHEN p_source_table IN ('ldsdok') THEN
                    p_source_table := 'ldsabzu';
               -- ergänzt mit #13330
               WHEN p_source_table IN ('belegpos') THEN
                    p_source_table := 'belegposabzu';
               ELSE

          END CASE;

          srcView := coalesce(TWawi.Abzu_Get_Viewname(p_source_table), p_source_table);

          IF srcView IS NULL THEN
             RAISE EXCEPTION 'FUNCTION twawi.abzu__create__from__source__by__srctbl : unknown SOURCE (TWawi.Abzu_Get_Viewname): %', p_source_table;
          END IF;

          RETURN QUERY
                 SELECT to_jsonb(abzu)
                   FROM twawi.abzu__create__from__source__by__srcview_parent_id__jsonb(srcView, srcParentID) AS abzu
          ;

        END $$ LANGUAGE plpgsql STRICT;

    -->               FUNCTION TWawi.Abzu__Create__from__source__by__srctbl_dbrid       RETURNS SETOF TWawi.View_All_Abzu;
    -- Fügt Datensätze in Ziel ein
    CREATE OR REPLACE FUNCTION TWawi.Abzu__Create__Insert__jsonb(
         IN in_j_rec_abzu  jsonb,
         IN trgView        varchar,
         IN trgParentID    varchar,
         IN trgMenge       numeric
         )
         RETURNS varchar
         AS $$
         DECLARE
            qry          VARCHAR;
            qty          NUMERIC;
            dbrid        VARCHAR;
            rec_abzu     TWawi.View_All_Abzu;
            _rec_steutxt record;
         BEGIN
          rec_abzu := jsonb_populate_record(rec_abzu, in_j_rec_abzu);
          --
          IF trgView NOT ILIKE 'twawi.%' THEN
             trgView := 'twawi.'||trgView;
           END IF;
          -- Anzahl ermitteln: Wenn es kein mengenbezogener Zuschlag ist, aus dem Vorgänger nehmen.
          -- Bei mengenbezogenen Zuschlägen wird die von außen hereingegebene Menge der Parentposition genommen.
          -- Die Menge hier zu ermitteln ist Kino. Dort wo die TWawi.Abzu_Copy-Funktion aufgerufen wird, dürfte die bekannt sein.
          qty:= IfThen(rec_abzu.az_type <> 'M', rec_abzu.az_anzahl, trgMenge);

          dbrid:=NULL;

          -- Insert auf den View der die entsprechende Abzu_Tabelle kapselt. In View_All_Abzu kann nicht geschrieben werden.
            -- ParentID als Literal da das Varchar oder Integer sein kann
            -- Typ-Wechsel von Abrufkosten (A) eines Rahmen werden zu Einmalkosten (E), da einmal pro Abruf verrechnet
            qry :=          'INSERT INTO ' || (trgView) || ' ( az_parent_id, '
              || E'\r\n' || '  az_type, az_pos, az_abz_id, az_anzahl, az_betrag,'
              || E'\r\n' || '  az_proz, az_canskonto, az_scode, az_sproz, az_konto, '
              || E'\r\n' || '  az_visible, az_txt, az_txt_rtf, az_txt_int, az_source_table,'
              || E'\r\n' || '  az_source_dbrid ) '
              || E'\r\n' || 'SELECT ' || Quote_Literal(trgParentID) || ','
              || E'\r\n' || ' $1,  $2,  $3,  $4,  $5, '
              || E'\r\n' || ' $6,  $7,  $8,  $9,  $10,'
              || E'\r\n' || ' $11, $12, $13, $14, $15,'
              || E'\r\n' || ' $16 '
              || E'\r\n' || ' RETURNING dbrid';

            -- Wir unterbinden automatisch Zuschläge mit Prozentsatz 0 und setzen die NULL (wg. Check_Constraints an Tabellenfeldern)
            rec_abzu.az_proz := NULLIF(Round(rec_abzu.az_proz, 4),0);

            SELECT * INTO _rec_steutxt FROM steutxt__steu_z__valid_follower_get(rec_abzu.az_scode); -- ACHTUNG SELECT INTO da sonst null zu "NOT ASSIGNED" führt

            -- Ausführen und DBRID des neuen Zuschlags merken
            EXECUTE qry INTO dbrid
            USING IfThen(rec_abzu.az_type ='A', 'E', rec_abzu.az_type), 1+TWawi.Abzu_Pos_Max(trgView, trgParentID::VARCHAR), rec_abzu.az_abz_id, qty, rec_abzu.az_betrag,
              rec_abzu.az_proz, rec_abzu.az_canskonto, _rec_steutxt.steu_z, coalesce(_rec_steutxt.steu_proz, 0), rec_abzu.az_konto,
              rec_abzu.az_visible, rec_abzu.az_txt, rec_abzu.az_txt_rtf, rec_abzu.az_txt_int, rec_abzu.az_table,
              rec_abzu.dbrid ;
            -- Hinweis: Einmalkosten werden nach kopieren von xyztable__a10_iud_srcabzu_done Triggern an der Zieltabelle als übernommen markiert.
           RETURN dbrid;
         END $$ LANGUAGE plpgsql;
    --

    -- Kopiert alle Zuschlägen einer Parentposition aus einem View für einen anderen View und Parent. Z.Bsp. Auftrag zu Rechnung
    CREATE OR REPLACE FUNCTION TWawi.Abzu_Copy(
         IN srcView     varchar,
         IN srcParentID varchar,
         IN trgView     varchar,
         IN trgParentID varchar,
         IN trgMenge    numeric
         )
         RETURNS        varchar[]
         AS $$
         DECLARE
           src          TWawi.View_All_Abzu;
           dbrid        varchar;
           newDbrids    varchar[];
         BEGIN

          -- Source-View abfragen und über alle noch nicht erledigten Zuschläge laufen
          FOR src IN SELECT *
                       FROM twawi.abzu__create__from__source__by__srcview_parent_id(srcView, srcParentID)
          LOOP

              newDBrids := newDbrids || TWawi.Abzu__Create__Insert(src, trgView, trgParentId, trgMenge);

          END LOOP;

          RETURN newDbrids;

         END $$ LANGUAGE plpgsql;

--

-- #19796 Funktion zur Ermittlung einer von der Anfrage abweichenden Mengeneinheit eines Angebots
CREATE OR REPLACE FUNCTION twawi.anfangebot__artmgc__get( _aang_id integer, _aart_aknr varchar ) RETURNS varchar AS $$

     WITH artikel_uf AS
     (SELECT prodat_languages.lang_artmgc_id( m_id ) AS xtt316,
             m_id,
             m_uf
        FROM artmgc
       WHERE m_ak_nr =  _aart_aknr
     )

    SELECT artikel_uf.xtt316
      FROM anfangebot
      JOIN anfart ON aart_id  = aang_aart_id
      JOIN artmgc ON m_mgcode = aart_m_id
                 AND m_ak_nr  = aart_ak_nr
      LEFT JOIN artikel_uf ON true
     WHERE aang_id = _aang_id
       AND round( artmgc.m_uf / nullif( artikel_uf.m_uf, 0 ), 4 ) = aang_preiseinheit
     LIMIT 1;

$$ LANGUAGE sql STABLE STRICT;
--
